
@begin
   include "segmentation.h"
@end

/*
 * methods of generated structures
 */

// -- feature_vector_s --
@begin
   methods feature_vector_s
@end

// -- feature_vectors_s --
@begin
   methods feature_vectors_s
@end

// -- LOCAL MOMENT FEATURES --

// -- lms_kernel_s --
@begin
   methods lms_kernel_s
@end

// -- lms_kernel_array_s --
@begin
   methods lms_kernel_array_s
@end

// -- lm_seg_s --
@begin
   methods lm_seg_s
@end

bool lm_seg_s::generate_convolution_kernels(image_s &a_img)
{/*{{{*/

   // - clear previously created kernels -
   kernels.clear();

   // - image parameters -
   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;

   // - create convolution kernels -
   unsigned k_idx = 0;
   do {
      const float *k_ptr = c_lm_kernels + k_idx*c_lm_kernel_size;
      const float *k_ptr_end = k_ptr + c_lm_kernel_size;
      unsigned offset = 0;
      do {
         const float *k_ptr_w_end = k_ptr + c_lm_kernel_side_size;
         do {
            if (*k_ptr != 0.0f) {
               kernels.push_blank();
               lms_kernel_s &kernel = kernels.last();
               kernel.set(offset,k_idx,*k_ptr);
            }
         } while(offset += pixel_step,++k_ptr < k_ptr_w_end);

         offset += line_size - c_lm_kernel_side_size*pixel_step;
      } while(k_ptr < k_ptr_end);
   } while(++k_idx < c_lm_kernel_cnt);

   // FIXME debug output - konvolution kernels
   /*fprintf(stderr,"kernels.used: %u\n",kernels.used);
   if (kernels.used != 0) {
      lms_kernel_s *ptr = kernels.data;
      lms_kernel_s *ptr_end = ptr + kernels.used;
      do {
         fprintf(stderr,"s: %u, t: %u, v: %f\n",ptr->src_off,ptr->trg_off,ptr->value);
      } while(++ptr < ptr_end);
   }*/

   return true;
}/*}}}*/

bool lm_seg_s::compute_per_pixel_lm_data(image_s &a_img)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_32F || c_lm_kernel_side_size > a_img.width || 
      c_lm_kernel_side_size > a_img.height || kernels.used == 0) {
      return false;
   }

   width = a_img.width - (c_lm_kernel_side_size - 1);
   height = a_img.height - (c_lm_kernel_side_size - 1);

   // - create data -
   feature_vectors.clear();
   feature_vectors.copy_resize(width*height);

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned image_ls = (a_img.width - (c_lm_kernel_side_size - 1))*pixel_step;

   unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
   unsigned char *ptr_end = ptr + (a_img.height - (c_lm_kernel_side_size - 1) - 1)*line_size + image_ls;

   do {
      unsigned char *ptr_w_end = ptr + image_ls;
      do {
         feature_vectors.push_blank();
         feature_vector_s &fv = feature_vectors.last();

         fv.copy_resize(c_lm_kernel_cnt);
         fv.used = fv.size;

         lms_kernel_s *k_ptr = kernels.data;
         lms_kernel_s *k_ptr_end = k_ptr + kernels.used;
         do {
            *(fv.data + k_ptr->trg_off) += *((float *)(ptr + k_ptr->src_off))*k_ptr->value;
         } while(++k_ptr < k_ptr_end);
      } while((ptr += pixel_step) < ptr_w_end);

      ptr += line_size - image_ls;
   } while(ptr < ptr_end);

   return true;
}/*}}}*/


