
@begin
   include "fft_seg.h"
@end

/*
 * methods of generated structures
 */

// -- fft_seg_s --
@begin
   methods fft_seg_s
@end

bool fft_seg_s::create_filter_bank(unsigned a_w_power,unsigned a_h_power)
{/*{{{*/

   spectrum_w_power = a_w_power;
   spectrum_h_power = a_h_power;

   // - size of spectrum image -
   unsigned spectrum_width = 1 << spectrum_w_power;
   unsigned spectrum_height = 1 << spectrum_h_power;

   // - clear bank of filters -
   filter_bank.clear();

   double lambda_step = -0.2;
   double rotation_step = (c_2pi_number)/rotation_cnt;

   double lambda = 8.0;
   unsigned f_idx = 0;
   do {
      double rotation = 0.0;
      unsigned r_idx = 0;
      do {
         filter_bank.push_blank();
         image_s &filter = filter_bank.last();
         filter.create(spectrum_width,spectrum_height,c_image_pixel_format_2x64F);

         // - compute gaabor wavelet in size of spectrum image -
         filter.gen_gaabor_function(lambda,rotation,0.5*c_pi_number,0.75,0.33);
         cassert(filter.io_compute_fft(true,spectrum_w_power,spectrum_h_power));
         cassert(filter.io_swap_quarters());

      } while(rotation += rotation_step,++r_idx < rotation_cnt);
   } while(lambda += lambda_step,++f_idx < freq_cnt);

   cassert(filter_bank.used == filter_bank_size);

   //FIXME debug image show
//#define DEBUG_CREATE_FILTER_BANK
#ifdef DEBUG_CREATE_FILTER_BANK
   {
      image_s src_img;
      string_s file_name;

      src_img.init();
      file_name.init();

      cassert(src_img.create(spectrum_width,spectrum_height,c_image_pixel_format_3x8U));

      unsigned f_idx = 0;
      do {
         image_s &filter = filter_bank[f_idx];
         cassert(src_img.DEBUG_io_convert_fft_to_3x8U(filter));

         file_name.setf("filter_bank/filter_%04d.bmp",f_idx);
         fprintf(stderr,"file: %s\n",file_name.data);

         src_img.save_to_bmp_file(file_name.data);
      } while(++f_idx < filter_bank.used);

      file_name.clear();
      src_img.clear();
   }
#endif

   return true;
}/*}}}*/

bool fft_seg_s::compute_responses_to_filter_bank()
{/*{{{*/
   if (filter_bank.used == 0 || spectrum.pixel_format == c_image_pixel_format_blank) {
      return false;
   }

   // - create responses image array -
   if (responses.used == 0) {
      responses.copy_resize(filter_bank.used);
      responses.used = filter_bank.used;
   }

   // - create response images -
   {
      image_s *ri_ptr = responses.data;
      image_s *ri_ptr_end = ri_ptr + responses.used;
      do {
         if (ri_ptr->pixel_format != c_image_pixel_format_2x64F || ri_ptr->width != spectrum.width || ri_ptr->height != spectrum.height) {
            ri_ptr->create(spectrum.width,spectrum.height,c_image_pixel_format_2x64F);
            ri_ptr->io_clear();
         }
      } while(++ri_ptr < ri_ptr_end);
   }

   {
      unsigned f_idx = 0;
      do {
         image_s &filter = filter_bank[f_idx];
         image_s &response = responses[f_idx];

         // - multiply images in spectrum (convolution) -
         response.io_trg_operator(spectrum,filter,c_image_operator_mul);

         response.io_swap_quarters(); // any sense ?
         response.io_compute_fft(false,spectrum_w_power,spectrum_h_power);
         response.io_swap_quarters();

      } while(++f_idx < filter_bank.used);
   }

   // FIXME debug output
//#define DEBUG_COMPUTE_RESPONSES_TO_FILTER_BANK
#ifdef DEBUG_COMPUTE_RESPONSES_TO_FILTER_BANK
   {
      unsigned r_idx = 0;
      do {
         image_s src_img;
         src_img.init();
        
         string_s str;
         str.init();

         image_s &img = responses[r_idx];

         //img.io_swap_quarters();
         //img.io_compute_fft(false,spectrum_w_power,spectrum_h_power);
         //img.io_swap_quarters();

         src_img.create(img.width,img.height,c_image_pixel_format_3x8U);
         src_img.DEBUG_io_convert_fft_to_3x8U(img);

         str.setf("filter_bank/filter_%04u.bmp",r_idx);
         fprintf(stderr,"file: %s\n",str.data);
         src_img.save_to_bmp_file(str.data);

         str.clear();
         src_img.clear();
      } while(++r_idx < responses.used);
   }
#endif

   return true;
}/*}}}*/

bool fft_seg_s::responses_to_32F()
{/*{{{*/
   if (responses.used == 0 || responses[0].pixel_format != c_image_pixel_format_2x64F) {
      return false;
   }

   image_s tmp_img;
   tmp_img.init();

   // - cycle throught responses -
   image_s *ri_ptr = responses.data;
   image_s *ri_ptr_end = ri_ptr + responses.used;
   do {
      tmp_img.create(ri_ptr->width,ri_ptr->height,c_image_pixel_format_32F);

      unsigned pixel_step = ri_ptr->pixel_step;
      unsigned line_size = ri_ptr->image_data_ptr->line_bytes;
      unsigned image_ls = ri_ptr->width*pixel_step;

      unsigned s_pixel_step = tmp_img.pixel_step;
      unsigned s_line_size = tmp_img.image_data_ptr->line_bytes;
      unsigned s_image_ls = tmp_img.width*s_pixel_step;

      unsigned char *ptr = ri_ptr->image_data_ptr->data + ri_ptr->y_pos*line_size + ri_ptr->x_pos*pixel_step;
      unsigned char *ptr_end = ptr + (ri_ptr->height - 1)*line_size + ri_ptr->width*pixel_step;
      unsigned char *t_ptr = tmp_img.image_data_ptr->data + tmp_img.y_pos*s_line_size + tmp_img.x_pos*s_pixel_step;
      do {
         unsigned char *ptr_w_end = ptr + image_ls;
         do {
            *((float *)t_ptr) = (float)*((double *)ptr);
         } while(t_ptr += s_pixel_step,(ptr += pixel_step) < ptr_w_end);

         ptr += line_size - image_ls;
         t_ptr += s_line_size - s_image_ls;
      } while(ptr < ptr_end);

      ri_ptr->swap(tmp_img);
   } while(++ri_ptr < ri_ptr_end);

   tmp_img.clear();

   return true;
}/*}}}*/

bool fft_seg_s::non_maxima_suppression(unsigned a_block_size)
{/*{{{*/
   if (responses.used == 0 || a_block_size == 0 || a_block_size > spectrum.width || a_block_size > spectrum.height || 
      responses[0].pixel_format != c_image_pixel_format_32F) {
      return false;
   }

   unsigned block_size_d2 = a_block_size >> 1;

   // - create nms_responses images -
   if (nms_responses.used == 0) {
      nms_responses.copy_resize(responses.used);
      nms_responses.used = responses.used;
   }

   // - create nms_response images -
   {
      image_s *ri_ptr = nms_responses.data;
      image_s *ri_ptr_end = ri_ptr + nms_responses.used;
      do {
         if (ri_ptr->pixel_format != c_image_pixel_format_32F || ri_ptr->width != spectrum.width || ri_ptr->height != spectrum.height) {
            ri_ptr->create(spectrum.width,spectrum.height,c_image_pixel_format_32F);
         }

         ri_ptr->io_clear();
      } while(++ri_ptr < ri_ptr_end);
   }

   unsigned pixel_step = responses[0].pixel_step;
   unsigned line_size = responses[0].image_data_ptr->line_bytes;
   unsigned image_ls = (responses[0].width - a_block_size)*pixel_step;

   // - cycle throught responses -
   unsigned r_idx = 0;
   do {
      image_s &response = responses[r_idx];
      image_s &nms_res = nms_responses[r_idx];

      // - cycle throught images -
      unsigned char *r_ptr = response.image_data_ptr->data + (response.y_pos + block_size_d2)*line_size + (response.x_pos + block_size_d2)*pixel_step;
      unsigned char *r_ptr_end = r_ptr + (response.height - (a_block_size + 1))*line_size + image_ls;
      unsigned char *n_ptr = nms_res.image_data_ptr->data + (nms_res.y_pos + block_size_d2)*line_size + (nms_res.x_pos + block_size_d2)*pixel_step;
      do {
         
         // - cycle throught lines -
         unsigned char *r_ptr_w_end = r_ptr + image_ls;
         do {
            float value = *((float *)r_ptr);

            // - cycle throught kernel -
            unsigned char *k_ptr = r_ptr - (block_size_d2*line_size + block_size_d2*pixel_step);
            unsigned char *k_ptr_end = k_ptr + (a_block_size*line_size + a_block_size*pixel_step);
            do {
               unsigned char *k_ptr_w_end = k_ptr + a_block_size*pixel_step;
               do {
                  if (*((float *)k_ptr) > value) {
                     break;
                  }
               } while((k_ptr += pixel_step) < k_ptr_w_end);

               if (k_ptr < k_ptr_w_end) {
                  break;
               }

               k_ptr += line_size - a_block_size*pixel_step;
            } while(k_ptr < k_ptr_end);

            if (k_ptr >= k_ptr_end) {
               *((float *)n_ptr) = value;
               //*((float *)n_ptr) = (float)r_idx;
            }
         } while(n_ptr += pixel_step,(r_ptr += pixel_step) < r_ptr_w_end);

         r_ptr += line_size - image_ls;
         n_ptr += line_size - image_ls;
      } while(r_ptr < r_ptr_end);
   } while(++r_idx < responses.used);

   return true;
}/*}}}*/

bool fft_seg_s::directional_non_maxima_suppression()
{/*{{{*/
   if (responses.used == 0 || responses[0].pixel_format != c_image_pixel_format_32F || freq_cnt != 1 || rotation_cnt != 8) {
      return false;
   }

   const unsigned c_nms_length = 5;
   const unsigned c_nms_length_d2 = c_nms_length >> 1;

   // - create nms_responses images -
   if (nms_responses.used == 0) {
      nms_responses.copy_resize(responses.used);
      nms_responses.used = responses.used;
   }

   // - create nms_response images -
   {
      image_s *ri_ptr = nms_responses.data;
      image_s *ri_ptr_end = ri_ptr + nms_responses.used;
      do {
         if (ri_ptr->pixel_format != c_image_pixel_format_32F || ri_ptr->width != spectrum.width || ri_ptr->height != spectrum.height) {
            ri_ptr->create(spectrum.width,spectrum.height,c_image_pixel_format_32F);
         }

         ri_ptr->io_clear();
      } while(++ri_ptr < ri_ptr_end);
   }

   unsigned pixel_step = responses[0].pixel_step;
   unsigned line_size = responses[0].image_data_ptr->line_bytes;
   unsigned image_ls = (responses[0].width - c_nms_length)*pixel_step;

   // - cycle throught responses -
   unsigned offset = c_nms_length_d2*line_size + c_nms_length_d2*pixel_step;
   unsigned offset_end = offset + (responses[0].height - (c_nms_length + 1))*line_size + image_ls;
   do {
      unsigned offset_w_end = offset + image_ls;
      do {

#define NON_MAXIMA_SUPPRESSION(RESPONSE_IDX,PIXEL_OFFSET) \
{\
   unsigned char *ptr = responses[RESPONSE_IDX].image_data_ptr->data + offset;\
   unsigned char *n_ptr = nms_responses[RESPONSE_IDX].image_data_ptr->data + offset;\
\
   unsigned char *t_ptr = ptr - c_nms_length_d2*(PIXEL_OFFSET);\
   unsigned char *t_ptr_end = t_ptr + c_nms_length*(PIXEL_OFFSET);\
   do {\
      if (*((float *)t_ptr) > *((float *)ptr)) {\
         break;\
      }\
   } while((t_ptr += (PIXEL_OFFSET)) < t_ptr_end);\
\
   if (t_ptr >= t_ptr_end) {\
      *((float *)n_ptr) = *((float *)ptr);\
   }\
}

         NON_MAXIMA_SUPPRESSION(0,pixel_step);
         NON_MAXIMA_SUPPRESSION(1,line_size + pixel_step);
         NON_MAXIMA_SUPPRESSION(2,line_size);
         NON_MAXIMA_SUPPRESSION(3,line_size - pixel_step);

         NON_MAXIMA_SUPPRESSION(4,pixel_step);
         NON_MAXIMA_SUPPRESSION(5,line_size + pixel_step);
         NON_MAXIMA_SUPPRESSION(6,line_size);
         NON_MAXIMA_SUPPRESSION(7,line_size - pixel_step);

      } while((offset += pixel_step) < offset_w_end);

      offset += line_size - image_ls;
   } while(offset < offset_end);

   // FIXME save debug images
   /*{
      image_s &res = nms_responses[3];
      res.io_normalize(res,0);

      image_s trg_img;
      trg_img.init();
      trg_img.create(res.width,res.height,c_image_pixel_format_3x8U);
      cassert(trg_img.io_convert(res));
      trg_img.save_to_bmp_file("zal_copy.bmp");
      trg_img.clear();
   }*/

   return true;
}/*}}}*/

bool fft_seg_s::reconstruction_test()
{/*{{{*/
   if (nms_responses.used == 0) {
      return false;
   }

   image_s f_img;
   f_img.init();
   f_img.create(spectrum.width,spectrum.height,c_image_pixel_format_2x64F);

   unsigned r_idx = 0;
   do {
      image_s &nms_res = nms_responses[r_idx];
      f_img.io_convert(nms_res);
      
      f_img.io_compute_fft(true,spectrum_w_power,spectrum_h_power);
      f_img.io_swap_quarters();

      f_img.io_operator(filter_bank[r_idx],c_image_operator_mul);
      f_img.io_compute_fft(false,spectrum_w_power,spectrum_h_power);
      f_img.io_swap_quarters();

      nms_res.io_convert(f_img);
   } while(++r_idx < nms_responses.used);

   f_img.clear();

   return true;
}/*}}}*/

bool fft_seg_s::get_nms_responses_max(image_s &a_img)
{/*{{{*/
   if (nms_responses.used == 0 || a_img.pixel_format != c_image_pixel_format_32F || a_img.width != spectrum.width || a_img.height != spectrum.height) {
      return false;
   }

   // - clear pixels of target image -
   a_img.io_clear();

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned image_ls = a_img.width*pixel_step;

   // - find max value for each pixel -
   unsigned r_idx = 0;
   do {
      image_s &response = nms_responses[r_idx];

      unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
      unsigned char *ptr_end = ptr + (a_img.height - 1)*line_size + image_ls;
      unsigned char *r_ptr = response.image_data_ptr->data + response.y_pos*line_size + response.x_pos*pixel_step;
      do {
         unsigned char *ptr_w_end = ptr + image_ls;
         do {
            //*((float *)r_ptr) > *((float *)ptr)?*((float *)ptr) = *((float *)r_ptr):0;
            *((float *)ptr) += *((float *)r_ptr);
         } while(r_ptr += pixel_step,(ptr += pixel_step) < ptr_w_end);

         ptr += line_size - image_ls;
         r_ptr += line_size - image_ls;
      } while(ptr < ptr_end);

   } while(++r_idx < nms_responses.used);

   return true;
}/*}}}*/

bool fft_seg_s::compute_seg_data_from_responses(unsigned a_width,unsigned a_height)
{/*{{{*/
   if (responses.used == 0 || spectrum.pixel_format == c_image_pixel_format_blank || a_width > spectrum.width || a_height > spectrum.height) {
      return false;
   }

   width = a_width;
   height = a_height;
   length = filter_bank_size;

   unsigned ref_x_pos = (spectrum.width - width)/2;
   unsigned ref_y_pos = (spectrum.height - height)/2;

   // - clear seg_data -
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   unsigned seg_data_size = width*height*length;
   unsigned seg_data_b_size = seg_data_size*sizeof(float);

   // - create seg_data -
   seg_data = (float *)cmalloc(seg_data_b_size);

   unsigned r_width = width;//responses[0].width;
   unsigned r_height = height;//responses[0].height;

   unsigned pixel_step = responses[0].pixel_step;
   unsigned line_size = responses[0].image_data_ptr->line_bytes;
   unsigned image_ls = r_width*pixel_step;

   // - cycle throught responses -
   unsigned r_idx = 0;
   do {
      //image_s &response = responses[r_idx];
      image_s response_ref;
      response_ref.init();

      response_ref.create_referred(ref_x_pos,ref_y_pos,r_width,r_height,responses[r_idx]);

      unsigned char *ptr = response_ref.image_data_ptr->data + response_ref.y_pos*line_size + response_ref.x_pos*pixel_step;
      unsigned char *ptr_end = ptr + (r_height - 1)*line_size + r_width*pixel_step;
      float *gf_ptr = seg_data + r_idx;

      float min_value = INFINITY;
      float max_value = -INFINITY;

      // - set values, and find minimal and maximal value -
      do {
         unsigned char *ptr_w_end = ptr + image_ls;
         do {
            register float value = (float)*((double *)ptr);

            (value < min_value)?min_value = value:0;
            (value > max_value)?max_value = value:0;

            *gf_ptr = value;
         } while(gf_ptr += gabor_response_size,(ptr += pixel_step) < ptr_w_end);

         ptr += line_size - image_ls;
      } while(ptr < ptr_end);

      // - normalize values (0.0f - 1.0f) -
      float diff = max_value - min_value;
      if (diff != 0.0f) {
         gf_ptr = seg_data + r_idx;
         float *gf_ptr_end = gf_ptr + seg_data_size;
         do {
            *gf_ptr = (*gf_ptr - min_value)/diff;
         } while((gf_ptr += gabor_response_size) < gf_ptr_end);
      }

      response_ref.clear();
   } while(++r_idx < responses.used);

//#define DEBUG_COMPUTE_GF_DATA_FROM_RESPONSES
#ifdef DEBUG_COMPUTE_GF_DATA_FROM_RESPONSES
   {
      float *gf_ptr = seg_data;
      float *gf_ptr_end = gf_ptr + r_width*r_height*gabor_response_size;
      do {
         float *gf_ptr_w_end = gf_ptr + gabor_response_size;
         do {
            fprintf(stderr,"%f\t",*gf_ptr);
         } while(++gf_ptr < gf_ptr_w_end);

         fputc('\n',stderr);
      } while(gf_ptr < gf_ptr_end);
   }
#endif

   return true;
}/*}}}*/

float fft_seg_s::compute_norm_matrix_distance(float *a_f,float *a_s)
{/*{{{*/
   float *f_ptr = a_f;
   float *f_ptr_end = f_ptr + gabor_response_size;
   float *s_ptr = a_s;

   /*float distance = 0.0f;
   do {
      register float value = *f_ptr - *s_ptr;
      distance += value*value;
   } while(++s_ptr,++f_ptr < f_ptr_end);

   distance = sqrt(distance);*/

   float distance = 0.0f;
   do {
      register float value = *f_ptr - *s_ptr;
      distance += value > 0.0f?value:-value;
   } while(++s_ptr,++f_ptr < f_ptr_end);

   return distance;
}/*}}}*/

bool fft_seg_s::create_image_from_data_distances(image_s &a_img)
{/*{{{*/
   if (seg_data == NULL ||
      width != a_img.width || height != a_img.height ||
      a_img.pixel_format != c_image_pixel_format_32F) {
      return false;
   }

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned image_ls = (width - 1)*pixel_step;

   unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
   unsigned char *ptr_end = ptr + (a_img.height - 2)*line_size + image_ls;
   float *gf_ptr = seg_data;

   do {
      unsigned char *ptr_w_end = ptr + image_ls;
      do {
         float max_value = -INFINITY;
         float *f_ptr = gf_ptr;
         float *f_ptr_end = gf_ptr + gabor_response_size;
         do {
            max_value < *f_ptr?max_value = *f_ptr:0;
         } while(++f_ptr < f_ptr_end);
         
         *((float *)ptr) = max_value;

      } while(gf_ptr += gabor_response_size,(ptr += pixel_step) < ptr_w_end);

      ptr += line_size - image_ls;
      gf_ptr += gabor_response_size;

   } while(ptr < ptr_end);

   return true;
}/*}}}*/

void fft_seg_s::get_feature_parameters_string(string_s &a_fp_str)
{/*{{{*/
   a_fp_str.setf("freq_cnt=%u rotation_cnt=%u",freq_cnt,rotation_cnt);
}/*}}}*/

bool fft_seg_s::get_features_MASK(image_s &a_mask,feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_FFT_FEATURES;

   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = 0;
   a_fd.height = 0;

   kernel_info_s ki = {0,0,1,1};

   unsigned vector_cnt = extract_masked_vectors(seg_data,&a_fd.fv_data,a_mask,ki,length);
   if (vector_cnt == c_idx_not_exist) {
      if (a_fd.fv_data != NULL) {
         cfree(a_fd.fv_data);
         a_fd.fv_data = NULL;
      }
      return false;
   }

   a_fd.fv_cnt = vector_cnt;
   a_fd.fv_length = length;

   return true;
}/*}}}*/

