
#ifndef __COOC_SEG_H
#define __COOC_SEG_H

@begin
   include "basic.h"
   include "mem_check.h"
   include "structures.h"
   include "atomic.h"
   include "bitmap.h"
   include "image.h"
   include "segmentation.h"
@end

/*
 * basic definition and constants
 */

const unsigned c_cooc_bin_size = 64;
const unsigned c_cooc_block_size = 32;

// - Haralick features -
const unsigned c_haralick_feature_size = 5;
const unsigned c_haralick_feature_b_size = c_haralick_feature_size*sizeof(float);

enum {
   c_haralick_energy = 0,
   c_haralick_entropy,
   c_haralick_contrast,
   c_haralick_correlation,
   c_haralick_homogenity,
};

/*
 * definition of generated structures
 */

// -- cooc_seg_s --
@begin
   struct
   <
   unsigned:bin_size
   unsigned:block_size
   unsigned:block_size_m1
   unsigned:mat_side
   unsigned:mat_size
   unsigned:mat_ui_b_size
   unsigned:mat_bf_b_size
   int:x_step
   int:y_step

   unsigned:width
   unsigned:height
   unsigned:length
   ui_ptr:cooc_data
   bf_ptr:norm_cooc_data
   bf_ptr:seg_data
   >
   
   not_generate: init clear

   additions {
      
      inline void init();
      inline void clear();
      inline bool setup(unsigned a_bin_size,unsigned a_block_size,int a_mx,int a_my);

      bool compute_per_pixel_float_window_cooccurence_data(image_s &a_img,unsigned a_x_step,unsigned a_y_step);
      inline bool compute_per_pixel_float_window_cooccurence_data(image_s &a_img);
      bool compute_stepping_cooccurence_data(image_s &a_img,unsigned a_x_step,unsigned a_y_step,unsigned a_block_step);

      bool normalize_data();
      bool compute_haralick_features();

      void get_feature_parameters_string(string_s &a_fp_str);
      inline bool get_features(feature_data_s &a_fd);
      bool get_features_MASK(image_s &a_mask,feature_data_s &a_fd);
   }

   cooc_seg_s;
@end

/*
 * inline methods of structure image_s
 */

// -- cooc_seg_s --
@begin
   inlines cooc_seg_s
@end

inline void cooc_seg_s::init()
{
   cooc_data = NULL;
   norm_cooc_data = NULL;
   seg_data = NULL;
}

inline void cooc_seg_s::clear()
{
   if (cooc_data != NULL) {
      cfree(cooc_data);
      cooc_data = NULL;
   }

   if (norm_cooc_data != NULL) {
      cfree(norm_cooc_data);
      norm_cooc_data = NULL;
   }

   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   init();
}

inline bool cooc_seg_s::setup(unsigned a_bin_size,unsigned a_block_size,int a_mx,int a_my)
{
   bin_size = a_bin_size;
   block_size = a_block_size;

   block_size_m1 = block_size - 1;
   mat_side = 256/bin_size;
   mat_size = mat_side*mat_side;
   mat_ui_b_size = mat_size*sizeof(unsigned);
   mat_bf_b_size = mat_size*sizeof(float);

   x_step = a_mx;
   y_step = a_my;

   return true;
}

inline bool cooc_seg_s::compute_per_pixel_float_window_cooccurence_data(image_s &a_img)
{/*{{{*/
   return compute_per_pixel_float_window_cooccurence_data(a_img,x_step,y_step);
}/*}}}*/

inline bool cooc_seg_s::get_features(feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_COOCCURENCE_FEATURES;

   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = width;
   a_fd.height = height;
   a_fd.fv_cnt = width*height;
   a_fd.fv_length = length;
   a_fd.fv_data = seg_data;
   seg_data = NULL;

   return true;
}/*}}}*/

#endif

