
@begin
   include "cooc_seg.h"
@end

/*
 * methods of generated structures
 */

// -- cooc_seg_s --
@begin
   methods cooc_seg_s
@end

bool cooc_seg_s::compute_per_pixel_float_window_cooccurence_data(image_s &a_img,unsigned a_x_step,unsigned a_y_step)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_8U || a_img.width < c_cooc_block_size || a_img.height < c_cooc_block_size || 
      a_x_step >= c_cooc_block_size || a_y_step >= c_cooc_block_size) {
      return false;
   }

   width = a_img.width - block_size_m1;
   height = a_img.height - block_size_m1;
   length = c_haralick_feature_size;

   // - clear cooc_data -
   if (cooc_data != NULL) {
      cfree(cooc_data);
      cooc_data = NULL;
   }

   // - create cooc_data -
   unsigned data_size = width*height*mat_size;
   unsigned data_b_size = data_size*sizeof(unsigned);
   cooc_data = (unsigned *)cmalloc(data_b_size);

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned image_wb_ls = (a_img.width - block_size_m1)*pixel_step;
   unsigned block_m_x_step_ls = (c_cooc_block_size - (1 + a_x_step))*pixel_step;

   // - compute image pointers -
   unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
   unsigned char *ptr_end = ptr + ((a_img.height - block_size_m1) - 1)*line_size + (a_img.width - block_size_m1)*pixel_step;
   unsigned *c_ptr = cooc_data;
   unsigned offset = a_y_step*line_size + a_x_step*pixel_step;

   // - window cooccurence matrix -
   unsigned w_cooc[mat_size];
   
   do {
      unsigned char *ptr_w_end = ptr + image_wb_ls;

      // - clear window matrix -
      memset(w_cooc,0,mat_ui_b_size);

      // - compute first pixel matrix -
      {
         unsigned char *b_ptr = ptr;
         unsigned char *b_ptr_end = b_ptr + (c_cooc_block_size - (1 + a_y_step))*line_size + block_m_x_step_ls;
         do {
            unsigned char *b_ptr_w_end = b_ptr + block_m_x_step_ls;
            do {
               register unsigned char f_val = *b_ptr/c_cooc_bin_size;
               register unsigned char s_val = b_ptr[offset]/c_cooc_bin_size;
               w_cooc[f_val*mat_side + s_val]++;
            } while((b_ptr += pixel_step) < b_ptr_w_end);

            b_ptr += line_size - block_m_x_step_ls;
         } while(b_ptr < b_ptr_end);
      }

      memcpy(c_ptr,w_cooc,mat_ui_b_size);
      ptr += pixel_step;
      c_ptr += mat_size;

      do {
         unsigned char *b_ptr = ptr;
         unsigned char *b_ptr_end = b_ptr + (c_cooc_block_size - a_y_step)*line_size;
         do {
            register unsigned char f_val = b_ptr[-1]/c_cooc_bin_size;
            register unsigned char s_val = b_ptr[-1 + offset]/c_cooc_bin_size;
            w_cooc[f_val*mat_side + s_val]--;

            f_val = b_ptr[c_cooc_block_size - (2 + a_x_step)]/c_cooc_bin_size;
            s_val = b_ptr[(c_cooc_block_size - (2 + a_x_step)) + offset]/c_cooc_bin_size;
            w_cooc[f_val*mat_side + s_val]++;
         } while((b_ptr += line_size) < b_ptr_end);

         memcpy(c_ptr,w_cooc,mat_ui_b_size);
      } while(c_ptr += mat_size,(ptr += pixel_step) < ptr_w_end);

      ptr += line_size - image_wb_ls;
   } while(ptr < ptr_end);

   return true;
}/*}}}*/

bool cooc_seg_s::compute_stepping_cooccurence_data(image_s &a_img,unsigned a_x_step,unsigned a_y_step,unsigned a_block_step)
{/*{{{*/
   if (a_img.pixel_format != c_image_pixel_format_8U || a_img.width < c_cooc_block_size || a_img.height < c_cooc_block_size || 
      a_x_step >= c_cooc_block_size || a_y_step >= c_cooc_block_size || a_block_step == 0) {
      return false;
   }

   width = (a_img.width - block_size_m1)/a_block_step;
   height = (a_img.height - block_size_m1)/a_block_step;

   // - clear cooc_data -
   if (cooc_data != NULL) {
      cfree(cooc_data);
      cooc_data = NULL;
   }

   // - create cooc_data -
   unsigned data_size = width*height*mat_size;
   unsigned data_b_size = data_size*sizeof(unsigned);
   cooc_data = (unsigned *)cmalloc(data_b_size);

   unsigned pixel_step = a_img.pixel_step;
   unsigned line_size = a_img.image_data_ptr->line_bytes;
   unsigned image_wb_ls = (width * a_block_step)*pixel_step;
   unsigned block_m_x_step_ls = (c_cooc_block_size - (1 + a_x_step))*pixel_step;

   // - compute image pointers -
   unsigned char *ptr = a_img.image_data_ptr->data + a_img.y_pos*line_size + a_img.x_pos*pixel_step;
   unsigned char *ptr_end = ptr + ((height - 1)*a_block_step)*line_size + image_wb_ls;
   unsigned *c_ptr = cooc_data;
   unsigned offset = a_y_step*line_size + a_x_step*pixel_step;

   do {
      unsigned char *ptr_w_end = ptr + image_wb_ls;

      // brute force
      do {
         unsigned char *b_ptr = ptr;
         unsigned char *b_ptr_end = b_ptr + (c_cooc_block_size - (1 + a_y_step))*line_size + block_m_x_step_ls;
         do {
            unsigned char *b_ptr_w_end = b_ptr + block_m_x_step_ls;
            do {
               register unsigned char f_val = *b_ptr/c_cooc_bin_size;
               register unsigned char s_val = b_ptr[offset]/c_cooc_bin_size;
               c_ptr[f_val*mat_side + s_val]++;
            } while((b_ptr += pixel_step) < b_ptr_w_end);

            b_ptr += line_size - block_m_x_step_ls;
         } while(b_ptr < b_ptr_end);
      } while(c_ptr += mat_size,(ptr += a_block_step*pixel_step) < ptr_w_end);

      ptr += (line_size - image_wb_ls) + (a_block_step - 1)*line_size;
   } while(ptr < ptr_end);

   return true;
}/*}}}*/

bool cooc_seg_s::normalize_data()
{/*{{{*/
   if (cooc_data == NULL) {
      return false;
   }

   if (norm_cooc_data != NULL) {
      cfree(norm_cooc_data);
      norm_cooc_data = NULL;
   }

   // -- create norm_cooc_data --
   norm_cooc_data = (float *)cmalloc(width*height*mat_bf_b_size);

   unsigned *c_ptr = cooc_data;
   unsigned *c_ptr_end = c_ptr + width*height*mat_size;
   float *nc_ptr = norm_cooc_data;
   do {
      unsigned sum = 0;

      unsigned *ptr = c_ptr;
      unsigned *ptr_end = ptr + mat_size;
      do {
         sum += *ptr;
      } while(++ptr < ptr_end);

      if (sum > 0) {
         do {
            *nc_ptr = *c_ptr/(float)sum;
         } while(++nc_ptr,++c_ptr < c_ptr_end);
      }
   } while(c_ptr < c_ptr_end);

   return true;
}/*}}}*/

bool cooc_seg_s::compute_haralick_features()
{/*{{{*/
   if (norm_cooc_data == NULL) {
      return false;
   }

   // - clear seg_data -
   if (seg_data != NULL) {
      cfree(seg_data);
      seg_data = NULL;
   }

   // - create seg_data -
   unsigned haralick_data_b_size = width*height*c_haralick_feature_b_size;
   seg_data = (float *)cmalloc(haralick_data_b_size);

   float row_sums[mat_side];
   float col_sums[mat_side];

   float *c_ptr = norm_cooc_data;
   float *c_ptr_end = c_ptr + width*height*mat_size;
   float *h_ptr = seg_data;
   do {
      float h_energy = 0;
      float h_entropy = 0;
      float h_contrast = 0;
      float h_correlation = 0;
      float h_homogenity = 0;

      // - compute correlation parameters -
      float cor_mi_x = 0;
      float cor_mi_y = 0;
      float cor_sigma_x = 1.0f;
      float cor_sigma_y = 1.0f;

      // - compute cor_mi_x, and row_sums -
      {
         float *ptr = c_ptr;
         float *ptr_end = ptr + mat_size;
         unsigned y = 0;
         do {
            row_sums[y] = 0;
            float *ptr_w_end = ptr + mat_side;
            do {
               row_sums[y] += *ptr;
            } while(++ptr < ptr_w_end);

            cor_mi_x += y*row_sums[y];
         } while(++y,ptr < ptr_end);
      }

      // - compute cor_mi_y, and col_sums -
      {
         float *ptr = c_ptr;
         float *ptr_end = ptr + mat_side;
         unsigned x = 0;
         do {
            col_sums[x] = 0;
            float *cl_ptr = ptr;
            float *cl_ptr_end = cl_ptr + mat_size;
            do {
               col_sums[x] += *cl_ptr;
            } while((cl_ptr += mat_side) < cl_ptr_end);

            cor_mi_y += x*col_sums[x];
         } while(++x,++ptr < ptr_end);
      }

      // - compute cor_sigma_x -
      {
         unsigned y = 0;
         do {
            register float value = y - cor_mi_x;
            cor_sigma_x += value*value*row_sums[y];
         } while(++y < mat_side);
      }

      // - compute cor_sigma_y -
      {
         unsigned x = 0;
         do {
            register float value = x - cor_mi_y;
            cor_sigma_y += value*value*col_sums[x];
         } while(++x < mat_side);
      }

      // - compute haralick features -
      float *ptr = c_ptr;
      float *ptr_end = ptr + mat_size;
      float y = 0;
      do {
         float *ptr_w_end = ptr + mat_side;
         float x = 0;
         do {
            h_energy += ptr[0]*ptr[0];

            register float value_p1 = ptr[0] + 1;
            h_entropy += value_p1*logf(value_p1);

            register float dd = x - y;
            h_contrast += dd*dd*ptr[0];

            h_correlation += x*y*ptr[0] - cor_mi_x*cor_mi_y;

            register float value = x - y;
            value = value < 0?-value:value;
            h_homogenity += ptr[0]/(1 + value);
         } while(++x,++ptr < ptr_w_end);
      } while(++y,ptr < ptr_end);

      h_contrast /= (float)mat_size;
      h_correlation /= cor_sigma_x*cor_sigma_y;

      h_ptr[c_haralick_energy] = h_energy;
      h_ptr[c_haralick_entropy] = h_entropy;
      h_ptr[c_haralick_contrast] = h_contrast;
      h_ptr[c_haralick_correlation] = -h_correlation;
      h_ptr[c_haralick_homogenity] = h_homogenity;

   } while(h_ptr += c_haralick_feature_size,(c_ptr += mat_size) < c_ptr_end);

   return true;
}/*}}}*/

void cooc_seg_s::get_feature_parameters_string(string_s &a_fp_str)
{/*{{{*/
   a_fp_str.setf("bin_size=%u block_size=%u x_step=%d y_step=%d",bin_size,block_size,x_step,y_step);
}/*}}}*/

bool cooc_seg_s::get_features_MASK(image_s &a_mask,feature_data_s &a_fd)
{/*{{{*/
   a_fd.feature_id = c_feature_id_COOCCURENCE_FEATURES;

   get_feature_parameters_string(a_fd.feature_parameters);

   a_fd.width = 0;
   a_fd.height = 0;

   kernel_info_s ki = {0,0,block_size,block_size};

   unsigned vector_cnt = extract_masked_vectors(seg_data,&a_fd.fv_data,a_mask,ki,length);
   if (vector_cnt == c_idx_not_exist) {
      if (a_fd.fv_data != NULL) {
         cfree(a_fd.fv_data);
         a_fd.fv_data = NULL;
      }
      return false;
   }

   a_fd.fv_cnt = vector_cnt;
   a_fd.fv_length = length;

   return true;
}/*}}}*/

