
@begin
   include "bitmap.h"
@end

/*
 * methods of structure bitmap_s
 */

bool bitmap_s::load_from_file(const char *a_file)
{/*{{{*/
   FILE *f = fopen(a_file,"rb");
   if (f == NULL) {
      return false;
   }

   cassert(fread(&fh,sizeof(bmp_file_header_s),1,f) == 1);
   if (fh.type != 0x4d42) {
      fclose(f);
      return false;
   }

   cassert(fread(&ih,sizeof(bmp_image_header_s),1,f) == 1);

   // FIXME not important check
   //ih.compression != 0 || ih.clr_used != 0

   if (ih.planes != 1 || ih.bit_cnt != 32) {
      fclose(f);
      return false;
   }

   clear();

   int image_size = ih.width*ih.height*4;

   // FIXME not important check
   /*if (ih.image_size != image_size) {
      fclose(f);
      return false;
   }*/

   int headers_size = sizeof(bmp_file_header_s) + sizeof(bmp_image_header_s);
   if (fh.off_bits > headers_size) {
      fseek(f,fh.off_bits - headers_size,SEEK_CUR);
   }

   data = (unsigned char *)cmalloc(image_size*sizeof(unsigned char));
   cassert(fread(data,image_size,1,f) == 1);

   fclose(f);

   return true;
}/*}}}*/

bool bitmap_s::save_to_file(const char *a_file)
{/*{{{*/
   FILE *f = fopen(a_file,"wb");
   if (f == NULL) {
      return false;
   }

   fwrite(&fh,sizeof(bmp_file_header_s),1,f);
   fwrite(&ih,sizeof(bmp_image_header_s),1,f);
   fwrite(data,ih.image_size,1,f);

   fclose(f);

   return true;
}/*}}}*/

