#!/usr/bin/python
#coding=utf8

from __base import *
from __pgsql import *
import re

TMP_img = os.path.join(TMP_DIR,"tmp.bmp")
TMP_seg_img = os.path.join(TMP_DIR,"tmp_seg.bmp")
TMP_seg_conv_img = os.path.join(TMP_DIR,"tmp_seg_conv.bmp")
TMP_feature_data = os.path.join(TMP_DIR,"tmp_feature_data.dat")

subs_re = re.compile(r'<.*?>')

obj_type_dict = {}
texture_type_dict = {}
texture_type_unknown_id = None

# ----------------------------------------------------------------------------
def process_exif_latitude(a_latitude):
   lst = a_latitude.replace(", "," ").replace(",",".").split(" ")
   return "%05.2f:%05.2f:%05.2f" % (float(lst[0]),float(lst[1]),float(lst[2]))

# ----------------------------------------------------------------------------
def process_exif_longitude(a_longitude):
   lst = a_longitude.replace(", "," ").replace(",",".").split(" ")
   return "%06.2f:%05.2f:%05.2f" % (float(lst[0]),float(lst[1]),float(lst[2]))

# ----------------------------------------------------------------------------
def process_exif(a_img):
   # {{{
   exif_f = f_pipe_execute("exif -m '%s'" % a_img)

   exp_time_str = ""
   exp_loc_lat_str = ""
   exp_loc_long_str = ""

   for exif_line in exif_f:
      if c_exp_time_exp in exif_line:
         date_str = exif_line[:-1].split("\t")[-1]
         if date_str != "0000:00:00 00:00:00":
            date_str_spl = date_str.split(" ")
            exp_time_str = "%s %s" % (date_str_spl[0].replace(":","-"),date_str_spl[1])
      elif c_exp_lat_dir_exp in exif_line:
         exp_loc_lat_str = exif_line[:-1].split("\t")[1] + exp_loc_lat_str
      elif c_exp_lat_exp in exif_line:
         exp_loc_lat_str += process_exif_latitude(exif_line[:-1].split("\t")[1])
      elif c_exp_long_dir_exp in exif_line:
         exp_loc_long_str = exif_line[:-1].split("\t")[1] + exp_loc_long_str
      elif c_exp_long_exp in exif_line:
         exp_loc_long_str += process_exif_longitude(exif_line[:-1].split("\t")[1])

   exif_f.close()

   if exp_loc_lat_str == "" or exp_loc_long_str == "":
      exp_loc_str = ""
   else:
      exp_loc_str = "%s,%s" % (exp_loc_lat_str,exp_loc_long_str)

   ret_list = [None,None]
   if exp_time_str != "":
      ret_list[0] = exp_time_str
   if exp_loc_str != "":
      ret_list[1] = exp_loc_str

   return ret_list
   # }}}

# ----------------------------------------------------------------------------
def exif_update(a_img_id,a_img):
   # {{{
   f_pgsql_execute("SELECT exp_time,exp_loc FROM images WHERE id=%d" % a_img_id)
   if db_cursor.rowcount != 1:
      f_pgsql_database_error()

   exp_result = db_cursor.fetchone()
   exp_time = exp_result[0]
   exp_loc = exp_result[1]

   if exp_time == None or exp_loc == None:
      exif_res = process_exif(a_img)

      if exif_res[0] != None:
         f_pgsql_execute("UPDATE images SET exp_time='%s' WHERE id=%d" % (exif_res[0],ARG_img_id))
         if db_cursor.rowcount != 1:
            f_pgsql_database_error()

      if exif_res[1] != None:
         s_exp_loc = "ST_GeographyFromText('SRID=4326; %s')" % DBin_geo_point(exif_res[1])
         f_pgsql_execute("UPDATE images SET exp_loc=%s WHERE id=%d" % (s_exp_loc,ARG_img_id))
         if db_cursor.rowcount != 1:
            f_pgsql_database_error()
   # }}}

# ------------------------------------------------------------------------------
def run_detection(a_img,a_img_id):
   # {{{
   global obj_type_dict

   detection_cmd = "%s/detection.py %s" % (BASE_DIR,a_img)
   res_f = f_pipe_execute(detection_cmd)
   for line in res_f:
      sub_strs = subs_re.findall(line)

      for sub_str in sub_strs:
         line_spl = line.split(sub_str)

         if "IMAGE_DB_ID" in sub_str:
            line = line_spl[0] + str(a_img_id) + line_spl[1]

         elif "OBJ_TYPE" in sub_str:
            obj_type_str = sub_str.split(":")[1]
            if obj_type_dict.has_key(obj_type_str):
               obj_type_id = obj_type_dict[obj_type_str]
            else:
               f_pgsql_execute("SELECT id FROM object_types WHERE name='%s'" % obj_type_str)
               if db_cursor.rowcount != 1:
                  f_pgsql_database_error()

               obj_type_id = db_cursor.fetchone()[0]
               obj_type_dict[obj_type_str] = obj_type_id

            line = line_spl[0] + str(obj_type_id) + line_spl[1]

         elif "DESCRIPTION" in sub_str:
            line = line_spl[0] + line_spl[1]

         else:
            err_msg("Unknown substitution string: %s" % sub_str)
            assert 0

      # - insert detected object into database -
      f_pgsql_execute("INSERT INTO objects VALUES(%s)" % line[:-1])
      if db_cursor.rowcount != 1:
         f_pgsql_database_error();

   res_f.close()
   # }}}

# ------------------------------------------------------------------------------
def create_color_to_texture_type_map(a_input):
   # {{{
   ctttm = {}

   for line in a_input:
      line_spl = line.split(";")
      texture_type_str = line_spl[1][:-1]

      if texture_type_dict.has_key(texture_type_str):
         texture_type_id = texture_type_dict[texture_type_str]
      else:
         f_pgsql_execute("SELECT id FROM texture_types WHERE name='%s'" % texture_type_str)
         if db_cursor.rowcount != 1:
            f_pgsql_database_error()

         texture_type_id = int(db_cursor.fetchone()[0])
         texture_type_dict[texture_type_str] = texture_type_id
         
      ctttm[int(line_spl[0])] = texture_type_id

   return ctttm
   # }}}

# ------------------------------------------------------------------------------
def run_segmentation(a_img,a_img_id):
   # {{{
   global texture_type_dict
   global texture_type_unknown_id

   # - convert image to bitmap with alpha channel -
   convert_cmd = "convert '%s' -matte %s" % (a_img,TMP_img)
   f_execute(convert_cmd)

   # - retrieve segmentation setup -
   SEG_setup = SETUP["segmentation"]
   SEG_method = SEG_setup["METHOD"]
   SEG_append_feature = SEG_setup["APPEND_FEATURE"]
   SEG_distance_method = SEG_setup["DISTANCE_METHOD"]
   SEG_centroid_count = SEG_setup["CENTROID_COUNT"]
   SEG_iteration_count = SEG_setup["ITERATION_COUNT"]

   feature_extract_cmd = "%s/segmentation extract-features %s '%s' '%s' %s" % (BIN_DIR,SEG_method,TMP_img,TMP_feature_data,SEG_append_feature)
   f_execute(feature_extract_cmd);

   segmentation_cmd = "%s/segmentation kmeans-raw-img '%s' %s %d %d '%s'" % (BIN_DIR,TMP_feature_data,SEG_distance_method,SEG_centroid_count,SEG_iteration_count,TMP_seg_img)
   f_execute(segmentation_cmd);

   classification_cmd = "%s/surface-classification '%s' '%s' '%s' '%s'" % (BIN_DIR,SETUP["surface-classification"]["SURFACE-CLASSIFICATION_CONFIG"],a_img,TMP_seg_img,TMP_seg_conv_img)
   classification_res_f = f_pipe_execute(classification_cmd)
   ctttm = create_color_to_texture_type_map(classification_res_f)
   classification_res_f.close()

   seg_to_pol_cmd = "%s/seg_to_pols.py %s" % (BASE_DIR,TMP_seg_conv_img)
   stp_res_f = f_pipe_execute(seg_to_pol_cmd)

   for line in stp_res_f:
      sub_strs = subs_re.findall(line)

      for sub_str in sub_strs:
         line_spl = line.split(sub_str)

         if "IMAGE_DB_ID" in sub_str:
            line = line_spl[0] + str(a_img_id) + line_spl[1]

         elif "TEXTURE_TYPE" in sub_str:
            texture_layer_id = int(sub_str.split(":")[1])

            if not ctttm.has_key(texture_layer_id):
               if texture_type_unknown_id == None:
                  f_pgsql_execute("SELECT id FROM texture_types WHERE name='unknown'")
                  if db_cursor.rowcount != 1:
                     f_pgsql_database_error()

                  texture_type_unknown_id = int(db_cursor.fetchone()[0])

               texture_type_id = texture_type_unknown_id
            else:
               texture_type_id = ctttm[texture_layer_id]

            line = line_spl[0] + str(texture_type_id) + line_spl[1]

         elif "DESCRIPTION" in sub_str:
            line = line_spl[0] + line_spl[1]

         else:
            err_msg("Unknown substitution string: %s" % sub_str)
            assert 0

      # - insert segment into database -
      f_pgsql_execute("INSERT INTO segments VALUES(%s)" % line[:-1])
      if db_cursor.rowcount != 1:
         f_pgsql_database_error()

   stp_res_f.close();
   # }}}

# - PROGRAM START - ============================================================

# - expected arguments <db_image_id> <image_uri> -
if len(sys.argv) != 3:
   err_msg("Expected exactly two arguments <db_image_id> <image_uri>")
   sys.exit(1)

ARG_img_id = int(sys.argv[1])
ARG_img_uri = sys.argv[2]

source_img = "%s/%s" % (FRAMES_TO_PROCESS_DIR,ARG_img_uri)
target_img = "%s/%s.%s" % (FRAMES_DIR,ARG_img_uri,FRAME_EXT)
thumb_target_img = "%s/%s.%s" % (FRAMES_THUMBS_DIR,ARG_img_uri,FRAME_EXT)

# - update exif information if needed -
exif_update(ARG_img_id,source_img)

# - convert image to required format -
convert_cmd = "convert '%s' -resize '640x640>' -quality 100%% '%s'" % (source_img,target_img)
result = f_execute(convert_cmd)
if result != 0:
   err_msg("Cannot convert image '%s' to image '%s'" % (source_img,target_img))
   f_pgsql_release_database(1)
   sys.exit(1)

# - create image thumbnail -
thumb_cmd = "convert '%s' -resize '%s>' -quality 100%% '%s'" % (source_img,THUMBNAIL_SIZE,thumb_target_img)
f_execute(thumb_cmd)

# - update image state to "in process" state -
f_pgsql_execute("UPDATE images SET state=%d WHERE id=%d" % (IMAGE_state_in_process,ARG_img_id))
if db_cursor.rowcount != 1:
   f_pgsql_database_error()

f_pgsql_commit();

# - remove image source -
rm_cmd = "rm '%s'" % source_img
f_execute(rm_cmd)

# - run image segmentation and classification -
run_segmentation(target_img,ARG_img_id)

#  - run object detection on ARG_trg_img
run_detection(target_img,ARG_img_id)

f_pgsql_release_database(0)
sys.exit(0)

