#!/usr/bin/python

from __base import *
from __pgsql import *
import time

def f_process_queue():

   while True:
      f_pgsql_execute("SELECT id,uri,video_id FROM images WHERE state=%d ORDER BY id LIMIT 1" % IMAGE_state_uploaded)

      if (db_cursor.rowcount != 0):
         image_res = db_cursor.fetchone()

         image_id = int(image_res[0])
         image_uri = image_res[1]
         image_video_id = int(image_res[2])

         # - process image -
         process_cmd = "%s/process_image.py %d '%s'" % (BASE_DIR,image_id,image_uri)
         result = f_execute(process_cmd);

         # - check status -
         if result != 0:
            err_msg("Failed to process image, uri: \"%s\", exited with status: %d" % (image_uri,result))

            # - update image state to "invalid" state -
            f_pgsql_execute("UPDATE images SET state=%d WHERE id=%d" % (IMAGE_state_invalid,image_id))
            if db_cursor.rowcount != 1:
               f_pgsql_database_error()

            # - remove image objects from database -
            f_pgsql_execute("DELETE FROM objects WHERE img_id=%d" % image_id)

            # - remove image segments from database -
            f_pgsql_execute("DELETE FROM segments WHERE img_id=%d" % image_id)

         else:

            # - update image state to "processed" state, file is in FRAMES_DIR -
            f_pgsql_execute("UPDATE images SET state=%d WHERE id=%d" % (IMAGE_state_processed,image_id))
            if db_cursor.rowcount != 1:
               f_pgsql_database_error()

            # - update state of image video -
            if image_video_id != 0:
               f_pgsql_execute("SELECT img_cnt,done_img_cnt FROM videos WHERE id=%d" % image_video_id)
               if db_cursor.rowcount != 1:
                  f_pgsql_database_error()

               image_video_res = db_cursor.fetchone()
               img_cnt = int(image_video_res[0])
               done_img_cnt = int(image_video_res[1]) + 1

               update_query = ""
               if done_img_cnt >= img_cnt:
                  update_query = "UPDATE videos SET state=%s, done_img_cnt=%d WHERE id=%d" % (VIDEO_state_processed,done_img_cnt,image_video_id)
               else:
                  update_query = "UPDATE videos SET done_img_cnt=%d WHERE id=%d" % (done_img_cnt,image_video_id)

               f_pgsql_execute(update_query)
               if db_cursor.rowcount != 1:
                  f_pgsql_database_error()

         f_pgsql_commit();

      else:
         time.sleep(1.0)

# - PROGRAM START - ============================================================

f_process_queue()
f_pgsql_release_database(0)

