#!/usr/bin/python

from __base import *
import glob

ABON_PATH = os.path.abspath(BIN_DIR)
CLASSIFIERS_path = SETUP["detection"]["CLASSIFIERS_PATH"]
CLASSIFIERS_params = SETUP["detection"]["CLASSIFIERS_PARAMS"]

os.environ['LD_LIBRARY_PATH'] = ABON_PATH

objects = []

# -- CLASS object_s ---------------------------------------------------------
class object_s:
   position = (0.0,0.0)
   scale = (0.0,0.0)
   object_type = ""

   # ---------------------------------------------------------------------------
   def __init__(self,a_object_type,a_descr):
      descr_lst = a_descr.split(", ")
   
      self.position = (float(descr_lst[0]),float(descr_lst[1]))
      self.scale = (float(descr_lst[2]),float(descr_lst[3]))
      self.object_type = a_object_type

   # ---------------------------------------------------------------------------
   def __str__(self):
      return "OBJECT: %s position: %s scale: %s" % (self.object_type,str(self.position),str(self.scale))

   # ---------------------------------------------------------------------------
   def get_db_repr(self):
      return "DEFAULT, <OBJ_TYPE:%s:>, <IMAGE_DB_ID>, ST_PointFromText('POINT(%f %f)'), %f, %f, '<DESCRIPTION>'" % (self.object_type,self.position[0],self.position[1],self.scale[0],self.scale[1])

# ------------------------------------------------------------------------------
def extract_params_from_xml(a_file_name):
   """get parameters from classifier XML file"""
   f = open(a_file_name, 'r')
   param = ""
   for line in f:
      if "<" in line:
         params = line.split("wki_params")			
         if(len(params)>1):
            param = params[1].split("\"")[1]
         break
   f.close()
   return param

# - PROGRAM START - ============================================================
if len(sys.argv) != 2:
   err_msg("Wrong parametr. Image file is required")
   sys.exit(1)
if not(os.path.exists(sys.argv[1])):
   err_msg("File %s not exist!" % sys.argv[1])
   sys.exit(1)

for classifier in glob.glob(os.path.join(CLASSIFIERS_path, '*.xml') ):
   class_name=os.path.splitext(os.path.basename(classifier))[0]

   # - loading parameters -
   param = ""
   if CLASSIFIERS_params.has_key(class_name):

      # - loading params from settings.py -
      param = CLASSIFIERS_params[class_name]

      # - in case __DEFAULT__ loading from classifier xml file -
      if param == "__DEFAULT__":
         param = extract_params_from_xml(classifier)

   else:

      # - loading from classifier xml file -
      param = extract_params_from_xml(classifier)

   # - run classifier -
   exec_string = "%s/abon -c%s %s '%s'" % (ABON_PATH,os.path.abspath(classifier),param,sys.argv[1])
   res_f = f_pipe_execute(exec_string)
   for line in res_f:

      # - store detection -
      objects.append(object_s(class_name,line))

   res_f.close()

# - print detections on stdout -
for obj in objects:
   print obj.get_db_repr()

sys.exit(0)

