
package eu.weknowit.media.imgproc.impl;

import java.util.Collection;
import java.util.List;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Calendar;
import java.net.URI;
import java.io.InputStream;
import java.io.File;
import java.io.StringReader;
import java.lang.StringBuilder;
import java.util.Date;

import javax.activation.MimeType;

import org.apache.log4j.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.commons.codec.binary.Base64;
import org.jdom.Document;
import org.jdom.input.SAXBuilder;

import eu.weknowit.media.imgproc.IImageProcessingService;

import nu.xom.*;


public class ImageProcessingServiceImpl implements IImageProcessingService {

    private static final Logger log = Logger.getLogger(ImageProcessingServiceImpl.class);
    // URL of the image processing server gateway
    private String serverUri = "http://pcpribyl-b.fit.vutbr.cz:9081";



    public void setServerUri (String serverUri)
    {
        this.serverUri = serverUri;
    }


    /***************************************************************************
     * Encodes a URI to a 'safe' format as required by the image processing server (no /_- chars)
     */
    private String encodeUri (String uri) throws Exception
    {
        Base64 b64 = new Base64(0);

        byte[] bytes = uri.getBytes("UTF-8");
        String ret = b64.encodeToString(bytes);
        ret = ret.replace("_", "(");
        return ret;
    }


    /***************************************************************************
     * Decodes URI.
     */
    private String decodeUri (String uri) throws Exception
    {
        try {
            Base64 b64 = new Base64(0);

            uri = uri.replace("(", "_");
            byte[] bytes = b64.decode(uri);

            return new String(bytes, "UTF-8");
        }
        catch(java.lang.Exception x) {
            log.error("cannot decode " + uri, x);
			throw x;
        }
    }
    
    
    /***************************************************************************
     * Executes query according to specified parameters.
     * @param methodName Name of the test for logging purposes.
     * @param params Parameters of the query to be executed.
     * @return XML document.
     */
    private Document executeQuery (String methodName, List<NameValuePair> params) throws Exception
    {
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/query", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpGet httpget = new HttpGet(requestUri);
        
				HttpClient httpclient = new DefaultHttpClient();
				ResponseHandler<String> responseHandler = new BasicResponseHandler();
				String responseBody = httpclient.execute(httpget, responseHandler);

				// parse the response
				Builder parser = new Builder();
				nu.xom.Document doc = parser.build(responseBody, requestUri.toString());
			
				//log.info(methodName + ": output: \n" + doc.toXML());
				
				// convert from nu.xom.Document to org.jdom.Document
				StringReader stringReader = new StringReader(doc.toXML());
				SAXBuilder builder = new SAXBuilder();
				return builder.build(stringReader);
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }
    
    
    /***************************************************************************
     * Returns formatted date and time string in format yyyy-mm-dd,hh:mm:ss.
     * @param d Date.
     * @return String Fromatted date and time string.
     */
    private String formatDate (Date d) {
      Calendar c = Calendar.getInstance();
		  c.setTime(d);
		  return String.format("%1$tY-%1$tm-%1$td,%1$tH:%1$tM:%1$tS", c);
    }
    
    
    /***************************************************************************
     * Uploads image on the server.
     */
    public HttpResponse image_put (MimeType mimeType, File file, Date expTime, String expLoc) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": expTime = " + expTime + ", expLoc = " + expLoc);
      
      // prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			if (expTime != null) params.add(new BasicNameValuePair("exp_time"  , this.formatDate(expTime)));
			if (expLoc != null && expLoc != "") params.add(new BasicNameValuePair("exp_loc", expLoc));
      
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/image", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpPut httpPut = new HttpPut(requestUri);
				httpPut.addHeader("Content-Type", mimeType.toString());
				httpPut.setEntity(new FileEntity(file, mimeType.toString()));

				HttpClient httpclient = new DefaultHttpClient();
				HttpResponse response = httpclient.execute(httpPut);

        return response;
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }
    
    
    /***************************************************************************
     * Downloads image from the server.
     */
    public HttpResponse image_get (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);
      
      // prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("uri", uri));
      
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/image", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpGet httpget = new HttpGet(requestUri);

				HttpClient httpclient = new DefaultHttpClient();
				HttpResponse response = httpclient.execute(httpget);

        return response;
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }
    
    
    /***************************************************************************
     * Deletes image from the server.
     */
    public HttpResponse image_delete (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);
      
      // prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("uri", uri));
      
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/image", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpDelete httpDelete = new HttpDelete(requestUri);

				HttpClient httpclient = new DefaultHttpClient();
				HttpResponse response = httpclient.execute(httpDelete);

        return response;
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }
    
    
    /***************************************************************************
     * Uploads video on the server.
     */
    public HttpResponse video_put (MimeType mimeType, File file, Date expTime, String expLoc) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": expTime = " + expTime + ", expLoc = " + expLoc);
      
      // prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			if (expTime != null) params.add(new BasicNameValuePair("exp_time"  , this.formatDate(expTime)));
			if (expLoc != null && expLoc != "") params.add(new BasicNameValuePair("exp_loc", expLoc));
      
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/video", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpPut httpPut = new HttpPut(requestUri);
				httpPut.addHeader("Content-Type", mimeType.toString());
				httpPut.setEntity(new FileEntity(file, mimeType.toString()));

				HttpClient httpclient = new DefaultHttpClient();
				HttpResponse response = httpclient.execute(httpPut);

        return response;
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }
    
    
    /***************************************************************************
     * Donwloads video from the server.
     */
    public HttpResponse video_get (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);
      
      // prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("uri", uri));
      
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/video", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpGet httpget = new HttpGet(requestUri);

				HttpClient httpclient = new DefaultHttpClient();
				HttpResponse response = httpclient.execute(httpget);

        return response;
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }
    
    
    /***************************************************************************
     * Deletes video from the server.
     */
    public HttpResponse video_delete (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);
      
      // prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("uri", uri));
      
      try {
				// query the server
				URI su = new URI(serverUri);

				URI requestUri = URIUtils.createURI(su.getScheme(), su.getHost(), su.getPort(), "/video", URLEncodedUtils.format(params, "UTF-8"), null);
				HttpDelete httpDelete = new HttpDelete(requestUri);

				HttpClient httpclient = new DefaultHttpClient();
				HttpResponse response = httpclient.execute(httpDelete);

        return response;
			}
			catch (java.net.URISyntaxException x) {
				log.error(methodName + ": Wrong server URI " + serverUri, x);
    		throw x;
			}
			catch (java.io.IOException x) {
				log.error(methodName + ": Can't connect to " + serverUri, x);
    		throw x;
			}
			catch (java.lang.Exception x) {
				log.error(methodName + ": Other exception: ", x);
    		throw x;
			}
    }

 
    /***************************************************************************
     * Returns list of resources.
     */       
    public Document query_getResourceList (Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": expTimeFrom = " + expTimeFrom + ", expTimeTo = " + expTimeTo + ", expLoc = " + expLoc + ", radius = " + radius);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "getResourceList"));		
			if (expTimeFrom != null) params.add(new BasicNameValuePair("exp_time_from", this.formatDate(expTimeFrom)));
			if (expTimeTo   != null) params.add(new BasicNameValuePair("exp_time_to"  , this.formatDate(expTimeTo)));
			if (expLoc != null && expLoc != "")  params.add(new BasicNameValuePair("exp_loc", expLoc));
			if (radius >= 0.0) params.add(new BasicNameValuePair("radius", Float.toString(radius)));
      
			return this.executeQuery(methodName, params);
    }
    
    
    /***************************************************************************
     * Returns state of given resource.
     */
    public Document query_getResourceState (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "getResourceList"));
			params.add(new BasicNameValuePair("resource_uri", uri));

			return this.executeQuery(methodName, params);
    }
    
    
    /***************************************************************************
     * Returns list of segments of given resource.
     */
    public Document query_getSegments (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "getSegments"));
			params.add(new BasicNameValuePair("resource_uri", uri));

			return this.executeQuery(methodName, params);
    }
    
    
    /***************************************************************************
     * Returns list of objects of given resource.
     */
    public Document query_getObjects (String uri) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "getObjects"));
			params.add(new BasicNameValuePair("resource_uri", uri));

			return this.executeQuery(methodName, params);
    }
    
    
    /***************************************************************************
     * Returns list of resources in which given object is in given segment type.
     */
    public Document query_isObjectInSegment (String uri, String segmentType, String objectType, Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri + ", segmentType = " + segmentType + ", objectType = " + objectType + ", expTimeFrom = " + expTimeFrom + ", expTimeTo = " + expTimeTo + ", expLoc = " + expLoc + ", radius = " + radius);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "isObjectInSegment"));
			if (uri != null && uri != "") params.add(new BasicNameValuePair("resource_uri", uri));
			params.add(new BasicNameValuePair("segment_type", segmentType));
			params.add(new BasicNameValuePair("object_type", objectType));
			if (expTimeFrom != null) params.add(new BasicNameValuePair("exp_time_from", this.formatDate(expTimeFrom)));
			if (expTimeTo   != null) params.add(new BasicNameValuePair("exp_time_to"  , this.formatDate(expTimeTo)));
			if (expLoc != null && expLoc != "")  params.add(new BasicNameValuePair("exp_loc", expLoc));
			if (radius >= 0.0) params.add(new BasicNameValuePair("radius", Float.toString(radius)));

			return this.executeQuery(methodName, params);
    }
    
    
    /***************************************************************************
     * Returns list of resources in which two segments of given segment types are adjacent.
     */
    public Document query_isSegmentAdjacent (String uri, String segmentType1, String segmentType2, Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri + ", segmentType1 = " + segmentType1 + ", segmentType2 = " + segmentType2 + ", expTimeFrom = " + expTimeFrom + ", expTimeTo = " + expTimeTo + ", expLoc = " + expLoc + ", radius = " + radius);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "isSegmentAdjacent"));
			if (uri != null && uri != "") params.add(new BasicNameValuePair("resource_uri", uri));
			params.add(new BasicNameValuePair("segment_type1", segmentType1));
			params.add(new BasicNameValuePair("segment_type2", segmentType2));
			if (expTimeFrom != null) params.add(new BasicNameValuePair("exp_time_from", this.formatDate(expTimeFrom)));
			if (expTimeTo   != null) params.add(new BasicNameValuePair("exp_time_to"  , this.formatDate(expTimeTo)));
			if (expLoc != null && expLoc != "")  params.add(new BasicNameValuePair("exp_loc", expLoc));
			if (radius >= 0.0) params.add(new BasicNameValuePair("radius", Float.toString(radius)));

			return this.executeQuery(methodName, params);
    }
    
    
    /***************************************************************************
     * Returns list of resources which are tagged by given tag.
     */
    public Document query_tag (String uri, String tag, Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception
    {
      String methodName = new Exception().getStackTrace()[0].getMethodName();
      log.info(methodName + ": uri = " + uri + ", tag = " + tag + ", expTimeFrom = " + expTimeFrom + ", expTimeTo = " + expTimeTo + ", expLoc = " + expLoc + ", radius = " + radius);

			// prepare parameters
			List<NameValuePair> params = new ArrayList<NameValuePair>();
			params.add(new BasicNameValuePair("q", "tag"));
			if (uri != null && uri != "") params.add(new BasicNameValuePair("resource_uri", uri));
			params.add(new BasicNameValuePair("tag", tag));
			if (expTimeFrom != null) params.add(new BasicNameValuePair("exp_time_from", this.formatDate(expTimeFrom)));
			if (expTimeTo   != null) params.add(new BasicNameValuePair("exp_time_to"  , this.formatDate(expTimeTo)));
			if (expLoc != null && expLoc != "")  params.add(new BasicNameValuePair("exp_loc", expLoc));
			if (radius >= 0.0) params.add(new BasicNameValuePair("radius", Float.toString(radius)));

			return this.executeQuery(methodName, params);
    }
    
}

