
package eu.weknowit.media.imgproc;

import java.util.Collection;
import java.util.Date;
import java.io.InputStream;
import java.io.File;

import javax.activation.MimeType;

import org.jdom.Document;
import org.apache.http.HttpResponse;

import eu.weknowit.datastorage.IWkiDataStorage;

/**
 * Image processing service.
 * Uses python imgproc server.
 * Note: resource = image | video
 */
public interface IImageProcessingService {

  /** IMAGE *******************************************************************/
  
  /**
   * Uploads image on the server.
   */
	HttpResponse image_put (MimeType mimeType, File file, Date expTime, String expLoc) throws Exception;
  
  /**
   * Downloads image from the server.
   */
	HttpResponse image_get (String uri) throws Exception;
	
	/**
   * Deletes image from the server.
   */
	HttpResponse image_delete (String uri) throws Exception;

  /** VIDEO *******************************************************************/

  /**
   * Uploads video on the server.
   */
	HttpResponse video_put (MimeType mimeType, File file, Date expTime, String expLoc) throws Exception;

  /**
   * Donwloads video from the server.
   */
	HttpResponse video_get (String uri) throws Exception;

  /**
   * Deletes video from the server.
   */	
	HttpResponse video_delete (String uri) throws Exception;

  /** QUERY *******************************************************************/

  /**
   * Returns list of resources.
   */
	Document query_getResourceList (Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception;

  /**
   * Returns state of given resource.
   */	
	Document query_getResourceState (String uri) throws Exception;

  /**
   * Returns list of segments of given resource.
   */	
	Document query_getSegments (String uri) throws Exception;

  /**
   * Returns list of objects of given resource.
   */	
	Document query_getObjects (String uri) throws Exception;

  /**
   * Returns list of resources in which given object is in given segment type.
   */	
	Document query_isObjectInSegment (String uri, String segmentType, String objectType, Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception;

  /**
   * Returns list of resources in which two segments of given segment types are adjacent.
   */	
	Document query_isSegmentAdjacent (String uri, String segmentType1, String segmentType2, Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception;

  /**
   * Returns list of resources which are tagged by given tag.
   */	
	Document query_tag (String uri, String tag, Date expTimeFrom, Date expTimeTo, String expLoc, float radius) throws Exception;	
	
}

