/*
								+---------------------------------+
								|                                 |
								|     ***   URI helpers   ***     |
								|                                 |
								|  Copyright   -tHE SWINe- 2010  |
								|                                 |
								|             URI.cpp             |
								|                                 |
								+---------------------------------+
*/

#include "../NewFix.h"
#include "../CallStack.h"
#include <string>
#include "URI.h"

/*
 *								=== CURI_Utils ===
 */

bool CURI_Utils::Get_FileName_Part(std::string &r_s_filename, const std::string &r_s_uri, const char *p_s_default)
{
	int b = 0, e = (r_s_uri.rfind('?') == std::string::npos)?
		r_s_uri.length() : r_s_uri.rfind('?');
	// do not parse after '?'

	int n_pos = r_s_uri.find("://");
	if(n_pos < e && n_pos != std::string::npos)
		b = n_pos + 3;
	// skip "://" (after "http")

	n_pos = r_s_uri.find(":", b);
	if(n_pos < e && n_pos != std::string::npos) {
		b = n_pos + 1;
		while(b < e && isdigit(r_s_uri[b]))
			++ b;
	}
	// skip ":[0-9]*" (port specifier)

	n_pos = r_s_uri.find("/", b);
	if(n_pos < e && n_pos != std::string::npos)
		b = n_pos + 1;
	while(b < e && r_s_uri[b] == '/')
		++ b;
	// skip '/'

	const char *p_s_file;
	if(b == e)
		p_s_file = p_s_default;
	else
		p_s_file = r_s_uri.c_str() + b;
	// is there a filename?

	return stl_ut::AssignCStr(r_s_filename, p_s_file);
}

bool CURI_Utils::GetByte(std::string &r_string, int n_position, uint8_t &r_n_byte)
{
	if(r_string.length() < n_position + 2)
		return false;
	// make sure index is valid

	char p_s_code[2] = {r_string[n_position] | 32, r_string[n_position + 1] | 32};
	r_string.erase(n_position, 2);
	// get code, and erase it from from string

	if(p_s_code[0] >= '0' && p_s_code[0] <= '9')
		r_n_byte = (p_s_code[0] - '0');
	else if(p_s_code[0] >= 'a' && p_s_code[0] <= 'f')
		r_n_byte = (p_s_code[0] - 'a' + 10);
	else
		return false;
	// read the first nibble

	r_n_byte <<= 4;
	// shift

	if(p_s_code[1] >= '0' && p_s_code[1] <= '9')
		r_n_byte |= p_s_code[1] - '0';
	else if(p_s_code[1] >= 'a' && p_s_code[1] <= 'f')
		r_n_byte |= p_s_code[1] - 'a' + 10;
	else
		return false;
	// read the second nibble

	return true;
}

/*
 *								=== ~CURI_Utils ===
 */
