/*
								+----------------------------------+
								|                                  |
								|      ***  Perlin noise  ***      |
								|                                  |
								|   Copyright  -tHE SWINe- 2007   |
								|                                  |
								|             Noise.h              |
								|                                  |
								+----------------------------------+
*/

#ifndef __PERLIN_NOISE_INCLUDED
#define __PERLIN_NOISE_INCLUDED

/*
 *	class CPerlinNoise
 *		- very simple perlin noise implementation
 */
class CPerlinNoise {
protected:
	static const int m_p_perm_table[512];

public:
	/*
	 *	static float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z)
	 *		- returns noise function value at f_x, f_y, f_z
	 */
	static float f_Noise(float f_x, float f_y, float f_z);

	/*
	 *	static float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z, float f_w)
	 *		- returns noise function value at f_x, f_y, f_z, f_w
	 */
	static float f_Noise(float f_x, float f_y, float f_z, float f_w);

protected:
	static float f_Fade(float f_t);
	static inline float f_Lerp(float f_t, float f_a, float f_b);
	static float f_Grad(int n_hash, float f_x, float f_y, float f_z);
	static float f_Grad(int n_hash, float f_x, float f_y, float f_z, float f_w);
};

#endif //__PERLIN_NOISE_INCLUDED
