-- TAKEN @ 2010-06-15

-- Table: sin_2010.dataset

-- DROP TABLE sin_2010.dataset;

CREATE TABLE sin_2010.dataset
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."1seq"'::regclass),
  "name" character varying,
  CONSTRAINT pk_id_dataset PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.dataset OWNER TO trecvid;

-- Table: sin_2010.descriptors

-- DROP TABLE sin_2010.descriptors;

CREATE TABLE sin_2010.descriptors
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."2seq"'::regclass),
  id_dataset bigint NOT NULL,
  id_bbox bigint NOT NULL,
  "name" character varying,
  path character varying,
  CONSTRAINT pk_id_descriptors PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.descriptors OWNER TO trecvid;

-- Table: sin_2010.files

-- DROP TABLE sin_2010.files;

CREATE TABLE sin_2010.files
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."2seq"'::regclass),
  id_dataset bigint NOT NULL,
  filename character varying,
  original_filename character varying,
  frame integer,
  vpl_id bigint,
  CONSTRAINT pk_id_files PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.files OWNER TO trecvid;

-- Table: sin_2010.classifier_storage

-- DROP TABLE sin_2010.classifier_storage;

CREATE TABLE sin_2010.classifier_storage
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."7seq"'::regclass),
  id_classifier bigint NOT NULL,
  "class" integer,
  "content" text,
  CONSTRAINT classifier_storage_pk PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.classifier_storage OWNER TO trecvid;

-- Table: sin_2010.classifier_results

-- DROP TABLE sin_2010.classifier_results;

CREATE TABLE sin_2010.classifier_results
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."6seq"'::regclass),
  id_classifier_storage bigint NOT NULL,
  id_desc bigint,
  "class" integer,
  response real[],
  CONSTRAINT classifier_results_pk PRIMARY KEY (id),
  CONSTRAINT classifier_results_descriptors_fk FOREIGN KEY (id_desc)
      REFERENCES sin_2010.descriptors (id) MATCH SIMPLE
      ON UPDATE NO ACTION ON DELETE NO ACTION
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.classifier_results OWNER TO trecvid;

-- Table: sin_2010.classifier

-- DROP TABLE sin_2010.classifier;

CREATE TABLE sin_2010.classifier
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."9seq"'::regclass),
  "name" character varying,
  description character varying,
  CONSTRAINT classifier_pk PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.classifier OWNER TO trecvid;

-- Table: sin_2010.bbox

-- DROP TABLE sin_2010.bbox;

CREATE TABLE sin_2010.bbox
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."4seq"'::regclass),
  "name" character varying,
  path character varying,
  CONSTRAINT pk_id_bbox PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.bbox OWNER TO trecvid;

-- Table: sin_2010.ann

-- DROP TABLE sin_2010.ann;

CREATE TABLE sin_2010.ann
(
  id bigint NOT NULL DEFAULT nextval('sin_2010."3seq"'::regclass),
  id_file bigint,
  "class" real,
  CONSTRAINT pk_id_ann PRIMARY KEY (id)
)
WITH (OIDS=FALSE);
ALTER TABLE sin_2010.ann OWNER TO trecvid;

-- Index: sin_2010.ix_ann

-- DROP INDEX sin_2010.ix_ann;

CREATE INDEX ix_ann
  ON sin_2010.ann
  USING btree
  (id, id_file);
