#!/bin/bash -e

# parse command line
while getopts "c:b:" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	b) BB_FILE="${OPTARG}" ;;
	?) echo "Usage: $0 -c config_file -b bbfile"; exit 1
    esac
done 

if [[ ! -f "$CONFIG_FILE" ]]
then
    echo "Config not specified."
    echo "Usage: $0 -c config_file -b bbfile"
    exit
fi

if [[ ! -f "$BB_FILE" ]]
then
    echo "File with black boxes not specified."
    echo "Usage: $0 -c config_file -b bbfile"
    exit
fi


#===========================================================================================
. ${CONFIG_FILE:=CONFIG} && . ${SCRIPT_DIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

echo ${TR_GT[*]}

: ${BB_TMP:=bb_file.tmp}

#get training set black boxes adr
${DB_HANDLER} listdsdesc "$DATASET" > "${BB_TMP}"

bbID=0

echo $BB_TMP

shopt -s extglob

#for all black boxes
for BB_NAME in $(cat "$BB_FILE" | cut -f 2 -d ' ')
do 

    #get the feature vector file
    FV_FILE=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 3 -d ' '` 
    BB_NAME=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 2 -d ' '`
    FV_COUNT=`cat "$BB_TMP" | grep "$BB_NAME " |wc -l |cut -f 1 -d ' '`  
    if (( FV_COUNT != 1 )) ; 
    then 
      echo "ERROR: Could not find an unique black box $BB_NAME for dataset $DATASET. Found $FV_COUNT lines:"; echo "$FV_FILE"; 
      exit; 
    fi
    
    echo 
    echo "Dataset and black box name from database:" $DATASET $BB_NAME
    echo "Feature vector file: $FV_FILE"
    
    JOB_ID=${CONFIG_FILE##*([[:graph:]])/}.${BB_FILE##*([[:graph:]])/}.$bbID
    (( bbID++ ))
    
    #estimate needed temp space and add it to  resources
    FILE_SIZE=$( stat -c%s "$FV_FILE" )
    (( FILE_SIZE = $FILE_SIZE / 1000000 + 100))
    RESOURCES2="'$RESOURCES,tmp_free=${FILE_SIZE}M'"
    
    RESOURCES2=$( sed 's/,/+/g' <<< $RESOURCES2 )
    
    echo "RESOURCES: $RESOURCES2"

    sge_submit "${SCRIPT_DIR}/SGE-SUM.sh" -hold_jid ${JOB_ID} -N ${JOB_ID}R -q $SGE_QUEUE -v BB_NAME=$BB_NAME,FV_FILE=$FV_FILE,RESOURCES2=$RESOURCES2,W_JOB_ID=${JOB_ID},TO_GO=$RESUBMIT_COUNT

done



rm -f "$BB_TMP"


