#!/bin/bash -e

# parse command line
while getopts "c:b:" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	b) BB_FILE="${OPTARG}" ;;
	?) echo "Usage: $0 -c config_file -b bbfile"; exit 1
    esac
done 

if [[ ! -f "$CONFIG_FILE" ]]
then
    echo "Config not specified."
    echo "Usage: $0 -c config_file -b bbfile"
    exit
fi

if [[ ! -f "$BB_FILE" ]]
then
    echo "File with black boxes not specified."
    echo "Usage: $0 -c config_file -b bbfile"
    exit
fi


#===========================================================================================
. ${CONFIG_FILE:=CONFIG} && . ${SCRIPT_DIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

: ${DATA_DIR:=${OUT_DIR}/DATA}

mkdir -p "${DATA_DIR}"

echo ${TR_GT[*]}

: ${BB_TMP:=bb_file.tmp}

#get training set black boxes adr
${DB_HANDLER} listdsdesc "$DATASET" > "${BB_TMP}"

FILE_COUNT=$( ${DB_HANDLER} dscont $DATASET | wc -l)

bbID=0

echo $BB_TMP

shopt -s extglob

declare -a BB_LIST
declare -a BB_TMP_LIST

#for all black boxes
for BB_NAME in $(cat "$BB_FILE")
do 

    #get the feature vector file
    FV_FILE=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 3 -d ' '` 
    REAL_BB_NAME=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 2 -d ' '`
    FV_COUNT=`cat "$BB_TMP" | grep "$BB_NAME " |wc -l |cut -f 1 -d ' '`  
    if (( FV_COUNT != 1 )) ; 
    then 
      echo "ERROR: Could not find an unique black box $BB_NAME for dataset $DATASET. Found $FV_COUNT lines:"; echo "$FV_FILE"; 
      exit; 
    fi

    BB_LIST[ ${#BB_LIST[*]}]=$REAL_BB_NAME    
    BB_TMP_LIST[ ${#BB_TMP_LIST[*]}]=$REAL_BB_NAME.tmp  
done

#download classifier results
for BB_NAME in "${BB_LIST[@]}"
do
    echo "${DB_HANDLER} clres ${CLASSIFIER_NAME} ${BB_NAME} ${CLASSES[@]} > TMP_$BB_NAME.tmp"
    ${DB_HANDLER} clres ${CLASSIFIER_NAME} ${BB_NAME} ${DATASET} "${CLASSES[@]}" > TMP_$BB_NAME.tmp
    
    #check if there are all lines
    if [[ $( wc -l < TMP_$BB_NAME.tmp) != ${#CLASSES[*]} ]]
    then
	die "Classifier ${CLASSIFIER_NAME} is computed for box $BB_NAME only for $( wc -l < TMP_$BB_NAME.tmp) classes out of ${#CLASSES[*]}."
    fi
done

#prepare fv files for each class
for clid in ${!CLASSES[@]}
do
    
    #prepare tmp files for each bb
    for bbid in ${!BB_LIST[@]}
    do
	head -n $(( $clid + 1 ))  TMP_${BB_LIST[ $bbid]}.tmp | tail -n 1 | gawk 'BEGIN{RS=" "}{print $1}' > ${BB_TMP_LIST[ $bbid]}
    done
    
    echo ${#BB_LIST[*]} >res.tmp
    echo $FILE_COUNT >>res.tmp
    paste "${BB_TMP_LIST[@]}" >>res.tmp
    
    ${BIN_DIR}/manipulateFV fromText ${DATA_DIR}/${DATASET}.${CLASSES[ $clid]}.fv < res.tmp

    rm res.tmp    
done

rm *.tmp



for clid in ${!CLASSES[@]}
do

    CL_FILE="${MODEL_DIR}/${CLASSIFIER_NAME}.${CLASSES[ $clid]}"

    if [ -s "$CL_FILE" ]
    then
        echo "TEST"
        ${BIN_DIR}/linearTest \
	    -neutral "$TST_NEUTRAL_HANDLING" \
    	    -c "${CL_FILE}" \
    	    -o "${PRED_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $clid]}.fv" \
    	    -fv "${DATA_DIR}/$DATASET.${CLASSES[ $clid]}.fv" \
    	    -gt "${GT_FILES[ $clid]}"\
    	    -l "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $clid]}.txt" 2>"${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $clid]}.err"
    else
        echo LEARNING
	${BIN_DIR}/linearExperiment \
    	    -bootstrap $BOOTSTRAP -maxMem $MAXMEM \
	    -norm $NORM -maxIt $MAXIT -class +1 -cv $CV  \
    	    -n 0 -C $C_SETTING -eps $EPS -bias $BIAS -solver $SOLVER -neutral "$NEUTRAL_HANDLING" \
    	    -o "${CL_FILE}" \
    	    -p "${PRED_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $clid]}.fv" \
    	    -fv "${DATA_DIR}/$DATASET.${CLASSES[ $clid]}.fv" \
    	    -gt "${GT_FILES[ $clid]}"\
    	    -l "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $clid]}.txt" 2>"${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $clid]}.err"
    fi
        
done

: ${ANN_TMP:=ann_file_$$.tmp}
: ${ANN_TMP2:=ann2_file_$$.tmp}

echo ${CLASSES[*]}
echo 'Getting annotations for all classes fro DB'
for class in "${CLASSES[@]}"
do
    $DB_HANDLER classann "$DATASET" "$class"
done > "$ANN_TMP"

echo 'Preprocessing the annotations'
${BIN_DIR}/toSingleClass.pl < "$ANN_TMP" > "$ANN_TMP2"

for class in "${CLASSES[@]}"
do
    ${BIN_DIR}/manipulateFV toText "${PRED_DIR}/${DATASET}.${CLASSIFIER_NAME}.$class.fv" | gawk 'BEGIN{ORS=" "}NR > 2{print $1} END{ORS="";print "\n"}' 
done  > RESULT.tmp
    cat RESULT.tmp |  ${BIN_DIR}/toSingleClass.pl \
    | gawk -vncl=${#CLASSES[*]} -vbb=$BB_NAME -vann="$ANN_TMP2" -vsmat=$SUPPRESS_MATRIX '
	BEGIN{
	    RS=" ";
	    sum = 0; 
	    good = 0;
	    for( gt = 1; gt <= ncl; gt++){
		for( pr = 1; pr <= ncl; pr++){
		    res[ pr, gt] = 0;
		}
	    }
	}
	{getline val < ann; res[ $1, val]++} 
	END{ 
	    ORS="";
	    for( gt = 1; gt <= ncl; gt++){
		for( pr = 1; pr <= ncl; pr++){
    		    if( smat != "TRUE"){
			print res[ pr, gt] ( pr == ncl? "\n" : "\t");
		    }
		    classCount[ gt] += res[ pr, gt];
		    if( pr == gt){
			classGood[ gt] +=  res[ pr, gt];
		    }
		}
	    }
	    for( gt = 1; gt <= ncl; gt++){
		good += res[ gt, gt];
		avg += classGood[ gt] / classCount[ gt];
	    }
	    
	    print bb, NR - good, good / NR, avg / ncl, "\n";
	}
	' 
    
rm -f "${ANN_TMP2}" "${ANN_TMP}" "${BB_TMP}"

: ${ANN_TMP:=_$$_ann.tmp}
: ${RES_TMP:=res.tmp}

declare -a ANN
echo 'Getting annotations for all classes from DB'
for class in "${!CLASSES[@]}"
do
    $DB_HANDLER classann "$DATASET" "${CLASSES[$class]}" | sed 's/ /\n/g' > "${CLASSES[$class]}${ANN_TMP}"
done

avgP=0

for class in "${!CLASSES[@]}"
do
    
    head -n $(( $class + 1)) RESULT.tmp | tail -n 1 | sed 's/ /\n/g' > "${RES_TMP}"
	
    if [ ! -s "$RES_TMP" ]
    then
        echo "ERROR: Missing results in DB for classifier '$CLASSIFIER_NAME', black box '$BB_NAME', dataset, '$DATASET' and class '${CLASSES[$class ]}'"
    fi
	
    if [[ -z "$TST_NEUTRAL_HANDLING" || "$TST_NEUTRAL_HANDLING" == IGNORE ]]
    then 
        p=$( paste "$RES_TMP" "${CLASSES[$class]}${ANN_TMP}" | sort -n -r | gawk '
        {
    	    if( $2 < 0){
	        neg++;
	    }
	    if( $2 > 0){
	        pos++;
	        avgP += pos / (pos + neg);
	    }
	}
	END{
	    print avgP / pos;
	}')
	    
        if [[ ! $SUPPRESS ]]
        then 
    	    printf " %f" $p
	fi
	avgP=$( echo "$avgP + $p" |bc )
    fi
done
    
avgP=$( echo "$avgP / ${#CLASSES[*]}" | bc -l)
    
printf " %f\n" $avgP

rm -f *.tmp
