#!/bin/bash -e
#
# Add classifiers into database
#

# parse command line
while getopts "c:b:d:s" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	b) BB_FILE="${OPTARG}" ;;
	d) OVERIDE_DATASET="${OPTARG}" ;;
	s) SUPPRESS=1 ;;
	?) echo "Usage: $0 -c config_file -b bbfile [-d dataset] "; exit 1
    esac
done 

if [[ ! -f "$CONFIG_FILE" ]]
then
    echo "Config not specified."
    echo "Usage: $0 -c config_file -b bbfile [-d dataset]"
    exit
fi

if [[ ! -f "$BB_FILE" ]]
     then
    echo "File with black boxes not specified."
    echo "Usage: $0 -c config_file -b bbfile [-d dataset]"
    exit
fi

. "${CONFIG_FILE}" && . ${SCRIPTDIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

if [ -n "$OVERIDE_DATASET" ]
then 
    DATASET=$OVERIDE_DATASET
fi

echo DATASET $DATASET
echo CLASSIFIER $CLASSIFIER_NAME

#check if the dataset is in database
IN_DB=$( ${DB_HANDLER} listds | grep "^$DATASET$")
if [ "$IN_DB" = "" ]; then
    die "ERROR: DATASET \"$DATASET\" is not in the database"
fi

#get number of files in the dataset
FILE_COUNT=$( ${DB_HANDLER} dscont $DATASET  | wc -l )
echo files $FILE_COUNT

: ${BB_TMP:=bb_file_$$.tmp}
: ${RES_TMP:=res_file_$$.tmp}
: ${ANN_TMP:=_$$_ann.tmp}


#get training set black boxes adr
${DB_HANDLER} listdsdesc "$DATASET" > "${BB_TMP}"
echo ${DB_HANDLER} listdsdesc "$DATASET"


declare -a ANN
echo 'Getting annotations for all classes fro DB'
for class in "${!CLASSES[@]}"
do
    $DB_HANDLER classann "$DATASET" "${CLASSES[$class]}" | sed 's/ /\n/g' > "${CLASSES[$class]}${ANN_TMP}"
done

#for all black boxes
for BB_NAME in $(cat "$BB_FILE" | cut -f 2 -d ' ')
do 

    #is the BB in DB?
    BB_NAME=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 2 -d ' '`
    FV_COUNT=`cat "$BB_TMP" | grep "$BB_NAME " |wc -l |cut -f 1 -d ' '`  
    if (( FV_COUNT != 1 )) ; 
    then 
      echo "ERROR: Could not find an unique black box $BB_NAME for dataset $DATASET. Found $FV_COUNT lines:"; echo "$FV_FILE"; 
      exit; 
    fi

    printf "%s" "$BB_NAME" 	
    avgP=0

    for class in "${!CLASSES[@]}"
    do
	${DB_HANDLER} clres "$CLASSIFIER_NAME" "$BB_NAME" "$DATASET" "${CLASSES[$class]}" | sed 's/ /\n/g' > "${RES_TMP}"
	
	if [ ! -s "$RES_TMP" ]
	then
	    echo "ERROR: Missing results in DB for classifier '$CLASSIFIER_NAME', black box '$BB_NAME', dataset, '$DATASET' and class '${CLASSES[$class ]}'"
	fi
	
	if [[ -z "$TST_NEUTRAL_HANDLING" || "$TST_NEUTRAL_HANDLING" == IGNORE ]]
	then 
	    p=$( paste "$RES_TMP" "${CLASSES[$class]}${ANN_TMP}" | sort -n -r | gawk '
	    {
		if( $2 < 0){
		    neg++;
		}
		if( $2 > 0){
		    pos++;
		    avgP += pos / (pos + neg);
		}
	    }
	    END{
		if( pos > 0 ){
    		    print avgP / pos;
    		} else {
    		    print 0;
    		}
	    }')
	    
	    if [[ ! $SUPPRESS ]]
	    then 
		printf " %f" $p
	    fi
	    avgP=$( echo "$avgP + $p" |bc )
	fi
    done
    
    avgP=$( echo "$avgP / ${#CLASSES[*]}" | bc -l)
    
    printf " %f\n" $avgP
    # IFS=$'\n' read -a RES -d $'\0' <<< $(    ${DB_HANDLER} clres "$CLASSIFIER_NAME" "$BB_NAME" "$DATASET" "${CLASSES[@]}")
    
    
done

rm -f *.tmp
