#!/bin/bash -e
#
# Add classifiers into database
#

# parse command line
while getopts "c:b:d:s" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	b) BB_FILE="${OPTARG}" ;;
	d) OVERIDE_DATASET="${OPTARG}" ;;
	s) SUPPRESS_MATRIX=TRUE ;;
	?) echo "Usage: $0 -c config_file -b bbfile [-d dataset] "; exit 1
    esac
done 

if [[ ! -f "$CONFIG_FILE" ]]
then
    echo "Config not specified."
    echo "Usage: $0 -c config_file -b bbfile [-d dataset]"
    exit
fi

if [[ ! -f "$BB_FILE" ]]
     then
    echo "File with black boxes not specified."
    echo "Usage: $0 -c config_file -b bbfile [-d dataset]"
    exit
fi


. "${CONFIG_FILE}" && . ${SCRIPTDIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

if [ -n "$OVERIDE_DATASET" ]
then 
    DATASET=$OVERIDE_DATASET
fi

echo DATASET $DATASET
echo CLASSIFIER $CLASSIFIER_NAME

#check if the dataset is in database
IN_DB=$( ${DB_HANDLER} listds | grep "^$DATASET$")
if [ "$IN_DB" = "" ]; then
    die "ERROR: DATASET \"$DATASET\" is not in the database"
fi

#get number of files in the dataset
FILE_COUNT=$( ${DB_HANDLER} dscont $DATASET  | wc -l )
echo files $FILE_COUNT

: ${BB_TMP:=bb_file_$$.tmp}


#get training set black boxes adr
${DB_HANDLER} listdsdesc "$DATASET" > "${BB_TMP}"
echo ${DB_HANDLER} listdsdesc "$DATASET"

: ${ANN_TMP:=ann_file_$$.tmp}
: ${ANN_TMP2:=ann2_file_$$.tmp}

echo ${CLASSES[*]}
echo 'Getting annotations for all classes fro DB'
for class in "${CLASSES[@]}"
do
    $DB_HANDLER classann "$DATASET" "$class"
done > "$ANN_TMP"

echo 'Preprocessing the annotations'
${BIN_DIR}/toSingleClass.pl < "$ANN_TMP" > "$ANN_TMP2"

#for all black boxes
for BB_NAME in $(cat "$BB_FILE" | cut -f 2 -d ' ')
do 

    #is the BB in DB?
    BB_NAME=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 2 -d ' '`
    FV_COUNT=`cat "$BB_TMP" | grep "$BB_NAME " |wc -l |cut -f 1 -d ' '`  
    if (( FV_COUNT != 1 )) ; 
    then 
      echo "ERROR: Could not find an unique black box $BB_NAME for dataset $DATASET. Found $FV_COUNT lines:"; echo "$FV_FILE"; 
      exit; 
    fi

    ${DB_HANDLER} clres "$CLASSIFIER_NAME" "$BB_NAME" "$DATASET" "${CLASSES[@]}" \
    | ${BIN_DIR}/toSingleClass.pl \
    | awk -vncl=${#CLASSES[*]} -vbb=$BB_NAME -vann="$ANN_TMP2" -vsmat=$SUPPRESS_MATRIX '
	BEGIN{
	    RS=" ";
	    sum = 0; 
	    good = 0;
	    for( gt = 1; gt <= ncl; gt++){
		for( pr = 1; pr <= ncl; pr++){
		    res[ pr, gt] = 0;
		}
	    }
	}
	{getline val < ann; res[ $1, val]++} 
	END{ 
	    ORS="";
	    for( gt = 1; gt <= ncl; gt++){
		for( pr = 1; pr <= ncl; pr++){
    		    if( smat != "TRUE"){
			print res[ pr, gt] ( pr == ncl? "\n" : "\t");
		    }
		    classCount[ gt] += res[ pr, gt];
		    if( pr == gt){
			classGood[ gt] +=  res[ pr, gt];
		    }
		}
	    }
	    for( gt = 1; gt <= ncl; gt++){
		good += res[ gt, gt];
		avg += classGood[ gt] / classCount[ gt];
	    }
	    
	    print bb, NR - good, good / NR, avg / ncl, "\n";
	}
	' 
    
done

rm -f "${ANN_TMP2}" "${ANN_TMP}" "${BB_TMP}"
