#!/bin/bash -e
#
# Add classifiers into database
#

# parse command line
while getopts "c:b:" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	b) BB_FILE="${OPTARG}" ;;
	?) echo "Usage: $0 -c config_file -b bbfile"; exit 1
    esac
done 

if [[ ! -f "$CONFIG_FILE" ]]
then
    echo "Config not specified."
    echo "Usage: $0 -c config_file -b bbfile"
    exit
fi

if [[ ! -f "$BB_FILE" ]]
     then
    echo "File with black boxes not specified."
    echo "Usage: $0 -c config_file -b bbfile"
    exit
fi


. "${CONFIG_FILE}" && . ${SCRIPTDIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

echo DATASET $DATASET
echo CLASSIFIER $CLASSIFIER_NAME

#check if the dataset is in database
IN_DB=$( ${DB_HANDLER} listds | grep "^$DATASET$")
if [ "$IN_DB" = "" ]; then
    die "ERROR: DATASET \"$DATASET\" is not in the database"
fi

#get number of files in the dataset
FILE_COUNT=$( ${DB_HANDLER} dscont $DATASET  | wc -l )
echo files $FILE_COUNT

: ${BB_TMP:=bb_file.tmp}

#get training set black boxes adr
${DB_HANDLER} listdsdesc "$DATASET" > "${BB_TMP}"
echo ${DB_HANDLER} listdsdesc "$DATASET"

#add the classifier
${DB_HANDLER} inscl "${CLASSIFIER_NAME}" "$CLASSIFIER_DESCRIPTION"
echo ${DB_HANDLER} inscl "${CLASSIFIER_NAME}" "$CLASSIFIER_DESCRIPTION"

#for all black boxes
for BB_NAME in $(cat "$BB_FILE" | cut -f 2 -d ' ')
do 

    #is the BB in DB?
    BB_NAME=`cat "$BB_TMP" | grep "$BB_NAME " |cut -f 2 -d ' '`
    FV_COUNT=`cat "$BB_TMP" | grep "$BB_NAME " |wc -l |cut -f 1 -d ' '`  
    if (( FV_COUNT != 1 )) ; 
    then 
      echo "ERROR: Could not find an unique black box $BB_NAME for dataset $DATASET. Found $FV_COUNT lines:"; echo "$FV_FILE"; 
      exit; 
    fi

    echo "Dataset and black box name from database:" $DATASET $BB_NAME
    
    for class in "${CLASSES[@]}"
    do
	${DB_HANDLER} insclinst "$CLASSIFIER_NAME" "$class" "$BB_NAME" "${MODEL_DIR}/${CLASSIFIER_NAME}.${class}.${BB_NAME}" "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${class}.${BB_NAME}.txt"
	${BIN_DIR}/manipulateFV toText "${PRED_DIR}/${DATASET}.${CLASSIFIER_NAME}.${class}.${BB_NAME}.fv" | gawk 'NR > 2 {print $0}' | ${DB_HANDLER} insclres "$CLASSIFIER_NAME" "$class" "$BB_NAME" "$DATASET" 
    done
done
