#!/bin/bash -e
## -o /dev/null
## -e /dev/null

START_TIME=$( date +%s)

. ${CONFIG_FILE} && . ${SCRIPT_DIR}/common.sh || exit $?

sge_prolog
(

  TMP_FV_FILE="${LOCAL_DIR}/fvfile.fv"


  for (( i = ${#CLASSES[*]} * (${SGE_TASK_ID} - 1) / $NBJOBS; i < ${#CLASSES[*]} * ${SGE_TASK_ID} / $NBJOBS; i++))
  do

     
    if [[ ! -f "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[$i]}.${BB_NAME}.txt" || 0 == $(grep '</body>' < "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[$i]}.${BB_NAME}.txt" | wc -w) ]]
    then 
    
        [[ -s $TMP_FV_FILE ]] || run cp $FV_FILE $TMP_FV_FILE
        
	TMP_CL_FILE="${LOCAL_DIR}/classifier.txt"
	
	echo "${BIN_DIR}/db_handler cl ${CLASSIFIER_NAME} ${BB_NAME} ${CLASSES[ $i]} > $TMP_CL_FILE"
	${BIN_DIR}/db_handler cl ${CLASSIFIER_NAME} ${BB_NAME} ${CLASSES[ $i]} > "$TMP_CL_FILE"
	
	if [ -s "$TMP_CL_FILE" ]
	then
	    echo "TEST"
	    ${BIN_DIR}/linearTest \
    		-neutral "$TST_NEUTRAL_HANDLING" \
    		-c "${TMP_CL_FILE}" \
    		-o "${PRED_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}.fv" \
    		-fv "${TMP_FV_FILE}" \
    		-gt "${GT_FILES[ $i ]}"\
    		-l "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}.txt" 2>"${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}.err"
	else
	    echo LEARNING
    	    ${BIN_DIR}/linearExperiment \
    		-bootstrap $BOOTSTRAP -maxMem $MAXMEM \
		-norm $NORM -maxIt $MAXIT -class +1 -cv $CV  \
    		-n 0 -C $C_SETTING -eps $EPS -bias $BIAS -solver $SOLVER -neutral "$NEUTRAL_HANDLING" \
    		-o "${MODEL_DIR}/${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}" \
    		-p "${PRED_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}.fv" \
    		-fv "${TMP_FV_FILE}" \
    		-gt "${GT_FILES[ $i ]}"\
    		-l "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}.txt" 2>"${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.${CLASSES[ $i]}.${BB_NAME}.err"
    	fi
    fi
        
    END_TIME=$( date +%s)
    (( DIFF= $END_TIME - $START_TIME ))
    if [[ "$DIFF" -gt "$SOFT_TIME_LIMIT" ]]
    then
	echo SOFT_TIME_LIMIT is over. Terminating computations. "'$DIFF' '$SOFT_TIME_LIMIT'"
	exit
    fi
    
    
  done
      
)
sge_epilog

END_TIME=$( date +%s)
(( DIFF= $END_TIME - $START_TIME ))
echo "DONE in $DIFF" 
