#!/bin/bash -e
## -o /dev/null
## -e /dev/null

START_TIME=$( date +%s)

. ${CONFIG_FILE} && . ${SCRIPT_DIR}/common.sh || exit $?

export LANG=""
export LC_CTYPE="POSIX"
export LC_NUMERIC="POSIX"
export LC_TIME="POSIX"
export LC_COLLATE="POSIX"
export LC_MONETARY="POSIX"
export LC_MESSAGES="POSIX"
export LC_PAPER="POSIX"
export LC_NAME="POSIX"
export LC_ADDRESS="POSIX"
export LC_TELEPHONE="POSIX"
export LC_MEASUREMENT="POSIX"
export LC_IDENTIFICATION="POSIX"
export LC_ALL=""



sge_prolog
(

    #check if all results are present 
    for i in "${CLASSES[@]}"
    do 
	if [[ ! -f "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.$i.${BB_NAME}.txt" || 0 == $(grep '</html>' < "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.$i.${BB_NAME}.txt" | wc -w) ]]
	then
	
    	    echo NOT COMPLETE  "${RES_DIR}/${DATASET}.$i.${BB_NAME}.txt"

	    if [[ $TO_GO -gt 0 ]]
	    then
		
		(( TO_GO-- ))
		
		RES3=$( sed 's/+/,/g' <<< $RESOURCES2 )
		
		echo "RESOURCES2 = '$RESOURCES2'"
		echo "RES3 = '$RES3'"
	    
		sge_submit "${SCRIPT_DIR}/SGE-SVM.sh" -t 1-$NBJOBS -N ${W_JOB_ID} -q $SGE_QUEUE -l $RES3 -v BB_NAME=$BB_NAME,FV_FILE=$FV_FILE
    	    
    		sge_submit "${SCRIPT_DIR}/SGE-SUM.sh" -hold_jid ${W_JOB_ID} -N ${W_JOB_ID}R -q $SGE_QUEUE -v BB_NAME=$BB_NAME,FV_FILE=$FV_FILE,RESOURCES2="$RESOURCES2",W_JOB_ID=${W_JOB_ID},TO_GO=$TO_GO
    		
    	    else
    		echo
    		echo ERROR - NO MORE RESUBMIT ATTEMPTS - FAILED
    		echo 
    	    fi
    	    
    	    exit 
	fi
    done
  
  gawk -f ${BIN_DIR}/sum.awk $( 
    for i in "${CLASSES[@]}"
    do 
      echo "${RES_DIR}/${DATASET}.${CLASSIFIER_NAME}.$i.${BB_NAME}.txt"
    done
  ) > $OUT_DIR/${DATASET}.${CLASSIFIER_NAME}.${BB_NAME}.txt

)
sge_epilog

END_TIME=$( date +%s)
(( DIFF= $END_TIME - $START_TIME ))
echo "DONE in $DIFF" 
