#!/bin/bash
#
#$ -o LOGS/$JOB_NAME.$TASK_ID.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$TASK_ID.$JOB_ID.err
#

. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?

sge_prolog
time (


HIS[${#HIS[*]}]=${OUTDIR}/${TITLE}/HIS/${LLF_ID}/${CODEBOOK_ID}/${HISTOGRAM_ID}.fv


# which files belong to me?
FROM=$(( ${#IMAGES[*]} * ( ${SGE_TASK_ID} - 1) / ${NBJOBS} )) 
TO=$(( ${#IMAGES[*]} * ( ${SGE_TASK_ID} ) / ${NBJOBS} )) 
COUNT=$(( $TO - $FROM ))

MY_IMAGES=("${IMAGES[@]:$FROM:$COUNT}")

# for each LLF
for LLF in "${LLFS[@]}" ; do
	parse3 "${LLF}"
	LLF_ID=${ID}

	FVS=FVS/${LLF_ID}
	LFVS=${LOCALDIR}/${FVS}
	RFVS=${REMOTEDIR}/${FVS}

	# for each CODEBOOK
	for CODEBOOK in "${CODEBOOKS[@]}" ; do
		parse "${CODEBOOK}"
		CODEBOOK_ID=${ID}

		CB=CBS/${LLF_ID}/${CODEBOOK_ID}.cb
		RCB=${REMOTEDIR}/${CB}

		SHARED_PARAMS="-suf .fv -dir \"${LFVS}/\" -c \"${RCB}\""
		NEXT_PARAMS=""

		# for each HISTOGRAM
		for HISTOGRAM in "${HISTOGRAMS[@]}" ; do
			parse "${HISTOGRAM}"
			HISTOGRAM_ID=${ID}
			HISTOGRAM_PARAMS=${ARG}

			HI=HIS/${LLF_ID}/${CODEBOOK_ID}/${HISTOGRAM_ID}-${SGE_TASK_ID}.fv
			RHI=${REMOTEDIR}/${HI}

			# is this HISTOGRAM file missing?
			if missing "${RHI}" ; then
				
				tempDir=`pwd`
				cd "$RFVS"
				# copy FVS files if missing
				if [ ! -d "${LFVS}" ] ; then
					run mkdir -p "${LFVS}"
					run time cp -r $( gawk "BEGIN{RS=\" \"}{ print \$1 \".fv\"}" <<< ${MY_IMAGES[*]%%*([[:space:]])+([[:graph:]])} ) "${LFVS}"
				fi
				cd "$tempDir"


				if [ "${NEXT_PARAMS}" != "" ] ; then
					NEXT_PARAMS="${NEXT_PARAMS} -NEXT ${HISTOGRAM_PARAMS} -o \"${RHI}\""
				else
					NEXT_PARAMS="${HISTOGRAM_PARAMS} -o \"${RHI}\""
				fi

				run mkdir -p "$(dirname "${RHI}")"
			fi

		done
		
		
		if [ "${NEXT_PARAMS}" != "" ] ; then
			# get histograms
			run "${LOCALBIN}/histogram" ${SHARED_PARAMS} ${HIS_SHARED_PARAMS} ${NEXT_PARAMS} \<\<\< \"${MY_IMAGES[*]%%*([[:space:]])+([[:graph:]])}\"
		fi

	done

	# rm FVS files
	run rm -rf "${LFVS}"

done

)
sge_epilog
