#!/bin/bash
#
#$ -o LOGS/$JOB_NAME.$TASK_ID.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$TASK_ID.$JOB_ID.err
#
# process given part of images according to SGE_TASK_ID
#

echo ==== WORKER FV ====


. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?

sge_prolog
time (

# which images belong to me?
PER=$((${#IMAGES[@]}/${NBJOBS}+1))
FROM=$((${PER}*(${SGE_TASK_ID}-1)))
MYIMAGES=("${IMAGES[@]:${FROM}:${PER}}")

run mkdir -p "${LOCALDIR}/IMAGES"


#create directories
# for each image
for IMAGE in "${MYIMAGES[@]}" ; do
	parse "${IMAGE}"
	IMAGE_ID=${ID}
	RIMAGE_NAME=${ARG}
	LIMAGE_NAME=${LOCALDIR}/IMAGES/${IMAGE_ID}.img

	# for each LLF
	for LLF in "${LLFS[@]}" ; do
		parse3 "${LLF}"
		LLF_ID=${ID}
		LLF_BB=${BB}
		LLF_PARAMS=${ARG}

		LTXT=${LOCALDIR}/TXT/${LLF_ID}
		LFVS=${LOCALDIR}/FVS/${LLF_ID}
		RFVS=${REMOTEDIR}/FVS/${LLF_ID}

		run mkdir -p "${LTXT}"
		run mkdir -p "${LFVS}"

		FVOUTDIR=${RFVS}
		run mkdir -p "${FVOUTDIR}"
	done
done


# for each image
for IMAGE in "${MYIMAGES[@]}" ; do
	parse "${IMAGE}"
	IMAGE_ID=${ID}
	RIMAGE_NAME=${ARG}
	LIMAGE_NAME=${LOCALDIR}/IMAGES/${IMAGE_ID}.img

	# for each LLF
	for LLF in "${LLFS[@]}" ; do
		parse3 "${LLF}"
		LLF_ID=${ID}
		LLF_BB=${BB}
		LLF_PARAMS=${ARG}

		LTXT=${LOCALDIR}/TXT/${LLF_ID}
		LFVS=${LOCALDIR}/FVS/${LLF_ID}
		RFVS=${REMOTEDIR}/FVS/${LLF_ID}

		# if FV file is missing
		if missing "${RFVS}/${IMAGE_ID}.fv" ; then

			# copy image if missing
			if missing "${LIMAGE_NAME}" ; then
				run cp "${RIMAGE_NAME}" "${LIMAGE_NAME}"
			fi

			FVFILE=${LFVS}/${IMAGE_ID}.fv
			FVOUTDIR=${RFVS}

			# extract features
			run "${LOCALBIN}/extractors/${LLF_BB}" -p \"${LLF_PARAMS}\" -i "${LIMAGE_NAME}" -o "${FVFILE}"

			# move FV file back
			run mv -f "${FVFILE}" "${FVOUTDIR}"
		fi

	done

	#run rm -f "${LIMAGE_NAME}"

done

)
sge_epilog
