#!/bin/bash
#
#$ -o LOGS/$JOB_NAME.$TASK_ID.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$TASK_ID.$JOB_ID.err
#


. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?


sge_prolog
time (

JOB_IDX=$(( SGE_TASK_ID - 1 ))

LLF_IDX=$(( JOB_IDX % ${#LLFS[@]} ))
CODEBOOK_IDX=$(( JOB_IDX / ${#LLFS[@]} ))

LLF=${LLFS[${LLF_IDX}]}
CODEBOOK=${CODEBOOKS[${CODEBOOK_IDX}]}

parse3 "${LLF}"
LLF_ID=${ID}

parse "${CODEBOOK}"
CODEBOOK_ID=${ID}
CODEBOOK_PARAMS=${ARG}

echo XXXXX2

RCBS=${REMOTEDIR}/CBS/${LLF_ID}
RFVS=${REMOTEDIR}/FVS/${LLF_ID}

FILE=${RCBS}/${CODEBOOK_ID}.cb

# is this .cb file missing?
if missing "${FILE}" ; then

        # run buildCodebook
        run mkdir -p "${RCBS}"

	log "Get files for building codebook"
        RND_FILES=$( gawk 'BEGIN{RS=" "}{print $0}' <<< "${IMAGES[*]%%*([[:space:]])+([[:graph:]])}" | randlines | head -n ${FILES_FOR_CB} | gawk '{ORS=" "; print $0}' )
        
        read -a FILES_TO_PROCESS <<< "$RND_FILES"

	SIZE=0
	IMG_COUT=0
	
	while [ ${SIZE} -le ${CB_MEM_LIMIT} ] ; do

	    if [ "${FILES_TO_PROCESS[${IMG_COUNT}]}" = "" ]; then
		break
	    fi
	    
	    INFO=$( $LOCALBIN/manipulateFV fastInfo  "${RFVS}/${FILES_TO_PROCESS[${IMG_COUNT}]}.fv")
	    FV_COUNT=$( echo "$INFO" | cut -f 3 -d ' ')
	    FV_DIM=$( echo "$INFO" | cut -f 5 -d ' ')
	    
	    (( SIZE += $FV_COUNT * $FV_DIM * 4 ))
	    (( IMG_COUNT++ ))
	    
	done
    
	log "The codebook will be build on $IMG_COUNT files which should occupy ${SIZE}B in memory"
	export LD_LIBRARY_PATH=/mnt/matylda1/ireznice/XXX
        run "${LOCALBIN}/buildCodebook" ${CODEBOOK_PARAMS} -suf .fv -dir "${RFVS}/" -o "${FILE}" "<<<" \"${FILES_TO_PROCESS[*]:0:IMG_COUNT}\"
fi

)
sge_epilog
