#!/bin/bash
#
# submit first script (helper_fv.sh) into SGE
#

# parse command line
while getopts ":c:h" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	?) echo "Usage: $0 [-c config_file]"; exit 1;;
    esac
done 

. ${CONFIG_FILE:=CONFIG} && . ${SCRIPTDIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

log "Task \"${TITLE}\" started..."

print_exports

run mkdir -p "${HOME}/LOGS"

if [ "${DATASET}" != "" ] ; then
	log "Fetching image list from dataset '${DATASET}'..."
	if [ "${DATASET_LIMIT}" != "" ] ; then
		run '${SCRIPTDIR}/dbmanip/db_handler dscontex "${DATASET}" | head -n "${DATASET_LIMIT}" | gawk "{ print \$2, \$1}"  > "${IMAGES_FILE}"'
	else
		run '${SCRIPTDIR}/dbmanip/db_handler dscontex "${DATASET}" | gawk "{ print \$2, \$1}"  > "${IMAGES_FILE}"'
	fi
fi

sge_submit helper_fv.sh -v TO_GO=$MAX_RESUBMIT -q all.q@@stable -l ram_free=128M,tmp_free=128M -N ${TITLE}_HELPER_FV
