#!/bin/bash
#
#$ -o LOGS/$JOB_NAME.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$JOB_ID.err
#
# merge histograms and delete partial histograms
#

echo 

. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?

sge_prolog
(

declare -a MISSING


# for each LLF
for LLF in "${LLFS[@]}" ; do
	parse3 "${LLF}"
	LLF_ID=${ID}

	# for each CODEBOOK
	for CODEBOOK in "${CODEBOOKS[@]}" ; do
		parse "${CODEBOOK}"
		CODEBOOK_ID=${ID}

		# for each HISTOGRAM
		for HISTOGRAM in "${HISTOGRAMS[@]}" ; do
			parse "${HISTOGRAM}"
			HISTOGRAM_ID=${ID}

			# check if file is missing
			FILE=${OUTDIR}/${TITLE}.${LLF_ID}.${CODEBOOK_ID}.${HISTOGRAM_ID}.fv
			if missing "${FILE}" ; then
			    
			    unset FILES
			    
			    for (( TASK_ID = 1; TASK_ID <= ${NBJOBS}; TASK_ID++ )) ; do
				FILES[${#FILES[*]}]="${OUTDIR}/${TITLE}/HIS/${LLF_ID}/${CODEBOOK_ID}/${HISTOGRAM_ID}-${TASK_ID}.fv"
			    done
			    
			    run "${LOCALBIN}/manipulateFV" merge $FILE ${FILES[*]}
			
			fi
			    
		done

	done

done

)
sge_epilog
