#!/bin/bash
#
#$ -o LOGS/$JOB_NAME.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$JOB_ID.err
#
# submit histogram creation processes if some of histograms are missing
#

. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?

sge_prolog
(

declare -a MISSING

# for each LLF
for LLF in "${LLFS[@]}" ; do
	parse3 "${LLF}"
	LLF_ID=${ID}

	# for each CODEBOOK
	for CODEBOOK in "${CODEBOOKS[@]}" ; do
		parse "${CODEBOOK}"
		CODEBOOK_ID=${ID}

		# for each HISTOGRAM
		for HISTOGRAM in "${HISTOGRAMS[@]}" ; do
			parse "${HISTOGRAM}"
			HISTOGRAM_ID=${ID}
			
			for (( TASK_ID = 1; TASK_ID <= $NBJOBS; TASK_ID++ )) ; do 

    			    # check if file is missing
			    FILE=${OUTDIR}/${TITLE}/HIS/${LLF_ID}/${CODEBOOK_ID}/${HISTOGRAM_ID}-${TASK_ID}.fv
			    if missing "${FILE}" ; then
				    MISSING[${#MISSING[*]}]=${FILE}
			    fi
			    
			done

		done

	done

done

if [ 0 != ${#MISSING[*]} ] ; then
	echo "Some files are missing (${#MISSING[*]}), submitting worker jobs (${NBJOBS})..."
	echo TO_GO $TO_GO

	if [[ ! ("$TO_GO" > 0) ]] ; then
	    die "Reached maximum number of resubmiting iterations. Something is probably wrong."
	fi

	# submit worker_histogram.sh
	sge_submit worker_histogram.sh -t 1-${NBJOBS} -q ${HIS_QUEUE} -l ${HIS_RESOURCES} -N ${TITLE}_WORKER_HISTOGRAM
	# submit myself
	sge_submit helper_histogram.sh -v TO_GO=$(($TO_GO - 1)) -q ${SGE_QUEUE} -N ${TITLE}_HELPER_HISTOGRAM -hold_jid ${TITLE}_WORKER_HISTOGRAM
else
	sge_submit merger.sh -q ${SGE_QUEUE} -N ${TITLE}_MERGE 
fi

)
sge_epilog
