#!/bin/bash -e
#
#$ -o LOGS/$JOB_NAME.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$JOB_ID.err
#
# submit descriptor extraction processes if some FV files are missing
#

echo ===== HELPER FV ==== 
. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?

echo CONFIG

sge_prolog
echo PROLOG
(

declare -a MISSING

# for each LLF
for LLF in "${LLFS[@]}" ; do
	parse3 "${LLF}"
	LLF_ID="${ID}"

	# for each IMAGE
	for IMAGE in "${IMAGES[@]}" ; do
		parse "${IMAGE}"
		IMAGE_ID=${ID}

		# check if file is missing
		FILE=${OUTDIR}/${TITLE}/FVS/${LLF_ID}/${IMAGE_ID}.fv
		if missing "${FILE}" ; then
			MISSING[${#MISSING[*]}]=${FILE}
		fi

	done
done

if [ 0 != ${#MISSING[*]} ] ; then
	echo "Some files (${#MISSING[*]}) are missing, submiting worker jobs (${NBJOBS})..."
	echo TO_GO $TO_GO
	
	if [[ ! ( "$TO_GO" > 0) ]] ; then
	    die "Reached maximum number of resubmiting iterations. Something is probably wrong."
	fi
	
	# estimate required disk space
	TMP_FREE=1024M
	# submit workers
	sge_submit worker_fv.sh -t 1-${NBJOBS} -q ${LLF_QUEUE} -l ${LLF_RESOURCES} -N ${TITLE}_WORKER_FV
	# submit myself
	sge_submit helper_fv.sh -v TO_GO=$(($TO_GO - 1)) -q ${SGE_QUEUE} -N ${TITLE}_HELPER_FV -hold_jid ${TITLE}_WORKER_FV
else
	# submit codebook construction
	sge_submit helper_codebook.sh -q ${SGE_QUEUE} -v TO_GO=${MAX_RESUBMIT} -N ${TITLE}_HELPER_CODEBOOK
fi

)
sge_epilog
