#!/bin/bash
#
#$ -o LOGS/$JOB_NAME.$JOB_ID.out
#$ -e LOGS/$JOB_NAME.$JOB_ID.err
#
# submit codebook construction processes if missing some of codebooks
#

echo "======  HELPER_CODEBOOK.sh ======"

. ${CONFIG_FILE?} && . ${SCRIPTDIR?}/common.sh || exit $?

sge_prolog
(

declare -a MISSING

# for each CODEBOOK
for CODEBOOK in "${CODEBOOKS[@]}" ; do
	parse "${CODEBOOK}"
	CODEBOOK_ID=${ID}

	# for each LLF
	for LLF in "${LLFS[@]}" ; do
		parse3 "${LLF}"
		LLF_ID=${ID}

		# check if file is missing
		FILE=${OUTDIR}/${TITLE}/CBS/${LLF_ID}/${CODEBOOK_ID}.cb
		if missing "${FILE}" ; then
			MISSING[${#MISSING[*]}]=${FILE}
		fi

	done

done

NBJOBS=$(( ${#CODEBOOKS[@]} * ${#LLFS[@]} ))

echo TO_GO $TO_GO

if [ 0 != ${#MISSING[*]} ] ; then
	echo "Some files are missing (${#MISSING[*]}), submitting worker jobs (${NBJOBS})..."
	echo TO_GO $TO_GO
	
	if [[ ! ( "$TO_GO" > 0) ]] ; then
	    die "Reached maximum number of resubmiting iterations. Something is probably wrong."
	fi

	# submit worker_codebook.sh
	sge_submit worker_codebook.sh -t 1-${NBJOBS} -l ${CB_RESOURCES} -q ${CB_QUEUE} -N ${TITLE}_WORKER_CODEBOOK
	
	# submit myself
	sge_submit helper_codebook.sh -v TO_GO=$(($TO_GO - 1)) -q ${SGE_QUEUE} -N ${TITLE}_HELPER_CODEBOOK -hold_jid ${TITLE}_WORKER_CODEBOOK
else
	# submit helper_histogram.sh
	sge_submit helper_histogram.sh -q ${SGE_QUEUE} -v TO_GO=${MAX_RESUBMIT} -N ${TITLE}_HELPER_HISTOGRAM
fi

)
sge_epilog
