#!/bin/bash 
#
# merge histograms and delete partial histograms
#

# parse command line
while getopts ":c:h" flag
do 
    case "$flag" in
	c) CONFIG_FILE="${OPTARG}" ;;
	?) echo "Usage: $0 [-c config_file]"; exit 1;;
    esac
done 


. ${CONFIG_FILE:=CONFIG} && . ${SCRIPTDIR:=$(readlink -f $(dirname $0))}/common.sh || exit $?

echo DATASET $DATASET

#check if the dataset is in database
IN_DB=$( $BINDIR/db_handler listds | grep "^$DATASET$")
if [ "$IN_DB" = "" ]; then
    die "ERROR: DATASET \"$DATASET\" is not in the database"
fi

#get number of files in the dataset
FILE_COUNT=$( $BINDIR/db_handler dscont $DATASET  | wc -l )
echo files $FILE_COUNT


echo LLFS "${LLF_FILE}"
echo CODEBOOKS "${CODEBOOKS_FILE}"
echo HISTOGRAMS "${HISTOGRAMS_FILE}"

read_to_array LLFS "${LLF_FILE}"
read_to_array CODEBOOKS "${CODEBOOKS_FILE}"
read_to_array HISTOGRAMS "${HISTOGRAMS_FILE}"

echo LLFS ${LLFS[@]}
echo CIDEBBOOKS ${CODEBOOKS[@]}
echo HISTOGRAMS ${HISTOGRAMS[@]}

# for each LLF
for LLF in "${LLFS[@]}" ; do
	parse3 "${LLF}"
	LLF_ID=${ID}
	LLF_BB=${BB}
	LLF_ARG=${ARG}

	# for each CODEBOOK
	for CODEBOOK in "${CODEBOOKS[@]}" ; do
		parse "${CODEBOOK}"
		CODEBOOK_ID=${ID}
		CODEBOOK_ARG=${ARG}
		
		CODEBOOK_FILE="${OUTDIR}/${TITLE}/CBS/${LLF_ID}/${CODEBOOK_ID}.cb"

		# for each HISTOGRAM
		for HISTOGRAM in "${HISTOGRAMS[@]}" ; do
			parse "${HISTOGRAM}"
			HISTOGRAM_ID=${ID}
			HISTOGRAM_ARG=${ARG}

			# check if file is missing
			FILE=${OUTDIR}/${TITLE}.${LLF_ID}.${CODEBOOK_ID}.${HISTOGRAM_ID}.fv
			if missing "${FILE}" ; then
			
			    log "MISSING FEATURE FILE \"$FILE\""
			
			else 
			    
			    BB_ID=${BB_PREFIX}.${LLF_ID}.${CODEBOOK_ID}.${HISTOGRAM_ID} 
			    
			    log 'is the BB in database?'
			    #is the BB in database?
			    IN_DB=$( $BINDIR/db_handler listbb | grep "^$BB_ID ")

			    if [ "$IN_DB" = "" ]; then
			    
				log "Inserting new black box \"$BB_ID\""
				
				PARAM="$BBOX_PATH -f $LLF_BB -p \"$LLF_ARG\" -c \"-c $CODEBOOK_FILE $HIS_SHARED_PARAMS $HISTOGRAM_ARG\""
				$BINDIR/db_handler insbb $BB_ID "${PARAM}"
			    else
				if [ -z "$ADD_ALL_BB" ]
				then
				
				    echo "Black box '$BB_ID' is already in DB."
			     
				    a=''
    				    while [[ !(( "$a" = "y" ) || ( "$a" = "n" ) || ( "$a" = "q" ) || ( "$a" = "a" )) ]]
    				    do 
    					echo " Do you want to add the descriptor to it? y[es]/n[o]/q[uit]/a[ll]:"
    					read a 
    				    done

    			    	    if [ "$a" = "q" ]; then
    					log "Selected QUIT"
    					exit
    				    fi
				    if [ "$a" = "a" ]; then
					log "Selected ALL"
    					ADD_ALL_BB=1
    				    fi
				    if [ "$a" = "n" ]; then
					echo "Skipping current descriptor file."
    					continue;
    				    fi
    				fi
			    fi
			    
			    log 'is the descriptor file already in database?'
			    #is the descriptor file already in database?
			    
			    if [[ ( -n "$( $BINDIR/db_handler listdsseldesc $DATASET $BB_ID)") ]]; then
				if [[ -z "$OVERWRITE_ALL" ]]; then
			    
    				    echo "Descriptor for datasets \"$DATASET\" and black box \"$BB_ID\" is already present in the database: $( $BINDIR/db_handler  listdsseldesc $DATASET $BB_ID | cut -d ' ' -f 3)"
				    a=''
    				    while [[ !(( "$a" = "y" ) || ( "$a" = "n" ) || ( "$a" = "q" ) || ( "$a" = "a" )) ]]
				    do 
					echo "Do you want to replace this descriptor file y[es]/n[o]/q[uit]/a[ll]:"
    					read a 
    				    done

    			    	    if [ "$a" = "q" ]; then
    					log "Selected QUIT"
    					exit
    				    fi
				    if [ "$a" = "a" ]; then
    					OVERWRITE_ALL=1
    				    fi
				    if [ "$a" = "n" ]; then
					echo "Skipping current descriptor file."
    					continue;
    				    fi
				fi
				
    				log '#delete old descriptor'
				$BINDIR/db_handler deldesc $DATASET $BB_ID 
				
			    fi
			    
			    log '#add the descriptor'
			    $BINDIR/db_handler insdesc $DATASET $BB_ID "$(readlink -f $FILE)"
			    
			    log Added descriptor "$(readlink -f $FILE)" for black box $BB_ID
			
			fi
			    
		done

	done

done
