<?php

require_once("DBMySql.inc.php");

class DBFaktory
{
	protected function __construct()
	{
	}
	
	/**
	 * Vrati instanci databazove vrstvy podle zadaneho engine
	 *
	 * @param string $engine
	 * @return instance 
	 * @static 
	 */
	public static function createDB($engine = 'MySQL')
	{
		$instace = null;
		
		//TODO nejaka konstrukce pro engine 

		$instace = new DBMySql();
			
		if (is_null($instace))
			throw new DBException("Cannot create DB instance with engine: ".$engine);
			
		return $instace;
	}
	/**
  	 * Staticka metoda zabezpeci retezec proti SQL injection pomoci escape znaku. Bere ohled na
  	 * zapnoti directivi magic_quotes ktera tuto ochranu dela automaticky. Tato funkce se pouziva pri ukladani do DB. 
 	 * 
 	 * Poznamka:
 	 * Pokud v kodu dale pouzivate takhle osetrenou promnenou musi se odstranit escape znaky funkci stripslasches
 	 * nebo myStripSlashesWithSpecialChars ktera jeste osetri specialni znaky.
 	 * 
 	 * @param string $text retezec pro osetreni
 	 * 
 	 * @return string osetreny retezec
 	 * 
 	 * @static 
 	 */
    public static function prepareTextToDB($text)
    {
    	return (get_magic_quotes_gpc() ? $text : addslashes($text));
    	//return mysql_real_escape_string($text);
    }

	/**
	 * funkce osetri v retezci specialni znaky jako napriklad & (na &amp;), <, >, ....
	 * 
	 * @param string $text retezec pro osetreni
	 * 
	 * @return string osetreny retezec
	 * 
	 * @static 
	 */
	public static function prepareTextFromDB($text)
	{
		return htmlspecialchars($text);
	}
	
	/**
	 * Statitcka metoda ktera slouzi pro odstraneni nezadouciho escapovani pri magic_quotes_gpc.
	 * Pouziva se jen v pripade kdy se data neukladaji do db ale maji byt dale zobrazeny 
	 *
	 * @param string $text
	 * @return string
	 * @static 
	 */
	public static function myStripSlasches($text)
	{
		return htmlspecialchars((get_magic_quotes_gpc() ? stripslashes($text) : $text));
	}
}

/**
 * Result set je trida pro zjednoduseni pristupu k datum po dotazu select 
 * jednotlive radky dotazu se dostavaji metodou next() pokud vysledek dotazu nic 
 * neobsahuje nebo uz nejsou zadne radky tak vrati metoda next() false. K jednotlivym 
 * sloupcum radky se pristupuje metodamy ve tvaru get{datovy typ} metody se staraji o spravny 
 * a osetreny vystup dat.
 * 
 * priklad pouziti:
 * 
 * <code>
 * 
$db->prepare("SELECT `id`, `bool`, `int` as cislo, `float`, `string`, `string2`, `string3` FROM test");
$db->execute();
$resultSet = $db->getResulSet();
 
while ($resultSet->next())
{
	echo $resultSet->getInteger('id'). "- ";
	echo $resultSet->getInteger('cislo'). "- ";
	echo $resultSet->getBool('bool'). "- ";
	echo $resultSet->getFloat('float'). "- ";
	echo $resultSet->getString('string'). "- ";
	echo $resultSet->getString('string2'). "- ";
	echo $resultSet->getString('string3'). "<br>";
	
}
 * </code>
 * 
 */
class ResultSet
{
	/**
	 * pole kde jsou ulozeny vysledky dotazu
	 *
	 * @var array
	 */
	private $record;
	
	/**
	 * pomocna promnena pro jeden radek 
	 *
	 * @var array
	 */
	private $currentRow = null;
	
	/**
	 * Metoda nacte dalsi radek dotazu. Pokud uz neni zadny radek tak vrati false.
	 *
	 * @return bool
	 */
	public function next()
	{
		if ($this->record === null) return false;
		
		if ($this->currentRow === null)
		{
			if (($this->currentRow = current($this->record)) === false)
				return false;
			else 
				return true;
		}
		if (($this->currentRow = next($this->record)) === false)
			return false;
		else 
			return true;
	}
	
	/**
	 * Konstruktor tridy. 
	 * 
	 * @param array $record 
	 * @return ResultSet
	 */
	public function __construct($record = null)
	{
		$this->record = $record;
		$this->currentRow = null;
		
		if (is_array($record))
			reset($this->record);
	}
	
	/**
	 * Vrati argument jako integer.
	 *
	 * @param mixed $row jmeno nebo cislo slopce
	 * @return integer
	 */
	public function getInteger($row)
	{
		return (int) $this->currentRow[$row];
	}
	
	/**
	 * Vrati argument jako float
	 *
	 * @param mixed $row jmeno nebo cislo slopce
	 * @return float
	 */
	public function getFloat($row)
	{
		return (float) $this->currentRow[$row];
	}
	
	/**
	 * Vrati argument jako objekt
	 *
	 * @param mixed $row jmeno nebo cislo slopce
	 * @return Object
	 */
	public function getObject($row)
	{
		$obj =	unserialize($this->currentRow[$row]);
		if ($obj === false)
			throw new DBException("Nelze vytvorit objekt z polozky: ".$row);
		return $obj;
	}
	
	/**
	 * Vrati argument jako string
	 *
	 * @param mixed $row jmeno nebo cislo slopce
	 * @return string
	 */
	public function getString($row)
	{
		return (string) DBFaktory::prepareTextFromDB($this->currentRow[$row]);
	}
	
	/**
	 * Vrati argument jako bool
	 *
	 * @param mixed $row jmeno nebo cislo slopce
	 * @return bool
	 */
	function getBool($row)
	{
		return (bool) ($this->currentRow[$row] == '1' ? true : false );
	}
}

?>
