<?php

require_once('DBFactory.inc.php');

class DB
{
	private static $instace = null;
	
	protected function __construct()
	{
	}

	public static function get()
	{
		global $_SETTING;

		if ( is_null(self::$instace))
		{
			self::$instace = DBFaktory::createDB($_SETTING['ENGINE']);
		}
		self::$instace->init($_SETTING['DB_URL'],$_SETTING['DB_USER'],$_SETTING['DB_PASS'], $_SETTING['DB_NAME']);
		
		return self::$instace;
	}

	const OBJECT = IDBPrototype::OBJECT;

	/**
	 * vysledek jako asocativni pole
	 */
	const ARRAY_A = IDBPrototype::ARRAY_A;

	/**
	 * vysledek jako ciselne pole
	 */
	const ARRAY_N = IDBPrototype::ARRAY_N;

	/**
	 * vytvori objekt a otevre DB
	 *
	 * @param string $dbhost      Jmeno serveru kde bezi MySQL
	 * @param string $dbuser      Jmeno uzivatele serveru
	 * @param string $dbpassword  Heslo k uctu
	 * @param string $dbname      Jmeno database, ktera se ma pouzivat
	 * @param string $character   kodovani v kterem se bude komunikovat ze serverem
	 * @param object $debuglog    debuglog!!!
	 *
	 */

	/**
	 * Metoda nastavi kodovani vystupnich dat z dotazu
	 *
	 * @param string $character_set kod kodovani
	 */
	public static function setCharacterResult($character_set = 'utf8')
	{
		self::get()->setCharacterResult($character_set);
	}
	/**
	 * Vybere ze kterou DB se bude pracovat
	 *
	 * @param string $dbName - jmeno databaze
	 */
	public static function select($dbName)
	{
		self::get()->select($dbName);
	}

	/**
	 * metoda vytvori predpripraveny (ulozeny) dotaz. Tj. do dotazu misto hodnot se vklada symbol '?'
	 * po teto metode se provede prikaz execute.
	 *
	 * @var string sql - SQL do$passHashtaz kde jsou promnene nahrazeny otaznikem
	 *
	 * @example
	 * <code>
	 * 	DB::prepare("SELECT jmeno, prijmeni, prava FROM uzivatel WHERE id = ?");
	 * </code>
	 *
	 * @param string $query
	 */
	public static function prepare($query)
	{
		self::get()->prepare($query);
	}

	/**
	 * Metoda vlozi data za otaznik do ulozeneho dotazu a pak tento prikaz provede.
	 * Metoda funguje stejne jako metoda query a vraci i stejny vysledek
	 *
	 * @var list of type parametrs
	 *
	 * @return int pripade dotazu delete|update|insert|replace vrati pocet ovlivnenych radku
	 *             pri selectu vrati pocet vybranych radku
	 */
	public static function execute()
	{
		return self::get()->execute(func_get_args());
	}


	/**
	 * funkce zpracuje dotaz a ulozi vysledek do Cache
	 *
	 * @param string $query Dotaz ktery chcete provest
	 *
	 * @return int pripade dotazu delete|update|insert|replace vrati pocet ovlivnenych radku
	 *             pri selectu vrati pocet vybranych radku
	 */
	public static function query($query)
	{
		return self::get()->query($query);
	}

	/**
	 * Funkce vrati skalarni (jednu) hodnotu
	 *
	 * @param string $query [nepovynny parametr]Dotaz
	 * @param int $x [default 0] hodnota. cislo sloupce
	 * @param int $y [default 0] hodnota. cislo radku
	 */
	public static function getVar($query = null, $x = 0, $y = 0)
	{
		return self::get()->getVar($query, $x, $y);
	}

	/**
	 * Vrati radek ze zanamu.
	 *
	 * @param string $query [nepovinny parametr] Dotaz
	 * @param const $output [default OBJECT] typ vracenych dat
	 * @param int $y cislo radu ktery se ma vratit
	 *
	 */
	public static function getRow($query = null, $output = IDBPrototype::OBJECT, $y = 0)
	{
		return self::get()->getRow($query, $output, $y);
	}

	/**
	 * Vrati sloupec ze zanamu.
	 *
	 * @param string $query [nepovinny parametr] Dotaz
	 * @param int $x cislo slopce ktery se ma vratit
	 *
	 */
	public static function getCol($query = null, $x = 0)
	{
		$res = self::get()->getCol($query, $x);
		if (is_array($res))
			return $res;
		else
			return array();
	}

	/**
	 * Vrati vysledek dotazu
	 *
	 * @param string $query [nepovinny parametr] Dotaz
	 * @param const $output [default OBJECT] typ vracenych dat
	 *
	 */
	public static function getResults($query = null, $output = IDBPrototype::OBJECT)
	{
		$res = self::get()->getResults($query, $output);

		if (is_array($res))
			return $res;
		else
			return array();
	}

	/**
	 * Vrati data z dotazu v podobe objektu ResultSet
	 *
	 * @param enum(ARRAY_A|ARRAY_N) $output typ indexu jakym se budou indexovat jednotlive parametry
	 * 		  (cislem | jmenem)
	 * @return ResultSet Object
	 */
	public static function getResulSet($output =  IDBPrototype::ARRAY_A)
	{
		return self::get()->getResulSet($output);
	}


	/**
	 * Vrati informace o slopecku
	 *
	 */
	public static function getColInfo($info_type = "name", $col_offset = -1)
	{
		return self::get()->getColInfo($info_type, $col_offset);
	}


	/**
	 * Vrati pocet radku po dotazu select
	 *
	 * @return pocet radku nebo -1
	 */
	public static function getNumRows ()
	{
		return self::get()->getNumRows();
	}

	/**
	 * Vrati ID posledniho INSERT|REPLACE dotazu
	 *
	 */
	public static function getLastID()
	{
		return self::get()->getLastID();
	}


	/**
  	 * Staticka metoda zabezpeci retezec proti SQL injection pomoci escape znaku. Bere ohled na
  	 * zapnoti directivi magic_quotes ktera tuto ochranu dela automaticky. Tato funkce se pouziva pri ukladani do DB. 
 	 * 
 	 * Poznamka:
 	 * Pokud v kodu dale pouzivate takhle osetrenou promnenou musi se odstranit escape znaky funkci stripslasches
 	 * nebo myStripSlashesWithSpecialChars ktera jeste osetri specialni znaky.
 	 * 
 	 * @param string $text retezec pro osetreni
 	 * 
 	 * @return string osetreny retezec
 	 * 
 	 * @static 
 	 */
    public static function prepareTextToDB($text)
    {
    	return DBFaktory::prepareTextToDB($text);
    }

	/**
	 * funkce osetri v retezci specialni znaky jako napriklad & (na &amp;), <, >, ....
	 * 
	 * @param string $text retezec pro osetreni
	 * 
	 * @return string osetreny retezec
	 * 
	 * @static 
	 */
	public static function prepareTextFromDB($text)
	{
		return DBFaktory::prepareTextFromDB($text);
	}
	
	/**
	 * Statitcka metoda ktera slouzi pro odstraneni nezadouciho escapovani pri magic_quotes_gpc.
	 * Pouziva se jen v pripade kdy se data neukladaji do db ale maji byt dale zobrazeny 
	 *
	 * @param string $text
	 * @return string
	 * @static 
	 */
	public static function myStripSlasches($text)
	{
		return DBFaktory::myStripSlasches($text);
	}

	/**
	 * Zjisti jestli existuje tabulka 
	 *
	 * @param string $tableName jmneo tabulky 
	 * @return  bool true pokud tabulka existuje
	 */
	public static function tableExist($tableName)
	{
		return self::get()->tableExist($tableName);
	}
	
	 /** Zacatek transakce (if supported).
     * @return void
     */
    public static function begin()
    {
    	self::get()->begin();
    }

    /**
     * potvrzeni transakce
     * @return void
     */
    public static function commit()
    {
    	self::get()->commit();
    }
    /**
     * Zruseni transakce
     * @return void
     */
    public static function rollback()
    {
    	self::get()->rollback();
    }
}//end class


?>
