
package QueryBot;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author isebek
 */
public class QueryBot {
    static String   DATA_SCHEMA = "climate";
    static String   DATA_TABLE = DATA_SCHEMA+".data";

    private static class Stats {

        private long cnt;
        public long cntSucc;
        public long cntFail;

    }

    private class QueryLoop implements Runnable {

        int sleepTime;
        BufferedWriter outLog;
        DBConn connection;
        final Stats stats;

        String queries[] = {
            "SELECT * FROM "+DATA_TABLE+" WHERE data @> '{&&}'::int[]",
            "SELECT * FROM "+DATA_TABLE+" WHERE data @> '{&&}'::int[]"
        };

        public QueryLoop(int sleepTime, BufferedWriter outLog, Stats stats){
            this.sleepTime = sleepTime;
            this.outLog = outLog;
            this.connection = new DBConn();
            this.stats = stats;

        }

        private int getRndVal(int min, int max){
            return min + (new Random()).nextInt(max-min);
        }

        public void run() {
            String q = "SELECT * FROM " + DATA_TABLE + " WHERE data @> '{&&}'::int[]";

            while(true){

                try {
                    Statement stmt = this.connection.conn.createStatement();

                    int queryi =  getRndVal(0, 10);
                    String q1 = q.replace("&&", new Integer(queryi*100).toString());

                    stmt = connection.conn.createStatement();
                    ResultSet rs = stmt.executeQuery("SELECT "+DATA_SCHEMA+".query_t('"+q1.replace("'", "\\'")+"');");
                    String timeStr = stmt.getWarnings().getNextWarning().getMessage().replaceAll("00:00:", "");
                    float atime = Float.parseFloat( timeStr );

                    synchronized(stats){
                        stats.cnt++;
                        if (atime>0.3) stats.cntFail++;
                        else stats.cntSucc++;
                    }

                    /*
                    ResultSet rs = stmt.executeQuery("SELECT "+DATA_SCHEMA+".query('"+(queries[queryi]).replace("'", "\\'").replace("&&", new Integer(getRndVal(-40, 40)*100).toString() )+"');");

                    int cnt = 0;
                    while ( rs.next() )
                        cnt++;
                    
                    // first warning skip, it is warning \'
                    String timestr = stmt.getWarnings().getNextWarning().getMessage().replaceAll("00:00:", "");
                    System.out.println(Thread.currentThread().getName()+": "+timestr + "; "+cnt);
                    stmt.close();
                    

                    outLog.write( "" + queryi + ";"+ (new Date()).getTime() +";"+timestr+ ";"+cnt+ "\n");
                    outLog.flush();
                     * */

                    Thread.sleep(this.sleepTime);

                    //
                } catch (InterruptedException ex) {
                    Logger.getLogger(QueryBot.class.getName()).log(Level.SEVERE, null, ex);
                //} catch (IOException ex) {
                //    Logger.getLogger(QueryBot.class.getName()).log(Level.SEVERE, null, ex);
                } catch (SQLException ex) {
                    Logger.getLogger(QueryBot.class.getName()).log(Level.SEVERE, null, ex);
                }

                
            }
        }
    }


    int threadsNum, sleepTime;
    String logFilename;

    public QueryBot(String logFilename, int sleepTime ){
        this.sleepTime = sleepTime;
        this.logFilename = logFilename;
        this.threadsNum = 1;
    }
    
    public QueryBot(String logFilename, int sleepTime, int threadsNum ){
        this.sleepTime = sleepTime;
        this.threadsNum = threadsNum;
        this.logFilename = logFilename;
    }

    @SuppressWarnings("empty-statement")
    public void run(){
        FileWriter fstream = null;
        ArrayList<Thread> threadList;

        Stats stats = new Stats();

        try {          
            fstream = new FileWriter(logFilename);
            BufferedWriter outLog = new BufferedWriter(fstream);
            outLog.write( "qindex;timestamp-ms;exectime-s;res-cnt\n");
            threadList = new ArrayList<Thread>();

            for(int i=0; i < threadsNum; i++){
                Thread t = new Thread(new QueryLoop(this.sleepTime, outLog, stats) );
                threadList.add(t);
                t.start();
                System.out.println("thread");
            }

            System.out.println("Waiting for CTRL+C");

            while (true){
                synchronized(stats){
                    System.out.println( "Query:"+stats.cnt+" fail: "+(double)stats.cntFail/stats.cnt*100 +"% ("+stats.cntFail+")");
                }
                try {
                    Thread.sleep(2000);
                } catch (InterruptedException ex) {
                    Logger.getLogger(QueryBot.class.getName()).log(Level.SEVERE, null, ex);
                }
            }

        } catch (IOException ex) {
            Logger.getLogger(QueryBot.class.getName()).log(Level.SEVERE, null, ex);
        }
    
    }


}
