
package QueryBot;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 *
 * @author chmelarp
 */
public class DBConn {

    // DB Connection
    public Connection conn = null;
    public String connectionStr = "jdbc:postgresql://minerva3.fit.vutbr.cz:5432/stream"; //minerva2
    public String user = "chmelarp";
    public String password = "teki7ivu";
    public String status = "N/A";
    
    // Dialogs etc.
    SimpleDateFormat formatter;

    /**
     * Sets an owner and connects to the default DB
     * @param owner
     */
    public DBConn() {

        this.formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        this.pgConnect();
    }

    /**
     * Log to the main view
     * @param String
     */
    public void log(String str) {
        Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, str);
    }

    /**
     *
     * @return
     */
    public void logTime(String str) {
        this.log(formatter.format(new java.util.Date()) + ": "+ str + "\n");
    }

    /**
     * Logs an error to the main view...
     * @param Object
     * @param String
     */
    public void error(Object o, String str) {
        this.logTime("Error at " + o.getClass().getName() + "\n" + str);
    }


    /**
     * Connect to the database...
     */
    public boolean pgConnect() {

        // String url = "jdbc:postgresql://localhost/test?user=fred&password=secret&ssl=true&sslfactory=org.postgresql.ssl.NonValidatingFactory";
        // Connection conn = DriverManager.getConnection(url);

        // find library
        try {
            Class.forName("org.postgresql.Driver");
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }

        // connect
        try {   // with SSL

            // set properties
            final Properties properties = new Properties();
            properties.put("user", user);
            properties.put("password", password);
            properties.put("ssl", "true");
            // don't be paranoid... see http://jdbc.postgresql.org/documentation/83/ssl-client.html#nonvalidating
            properties.put("sslfactory", "org.postgresql.ssl.NonValidatingFactory");

            conn = DriverManager.getConnection(connectionStr, properties);
            status = "... connected using SSL";
            this.logTime("... connected using SSL");
        } catch (SQLException ex) {
            this.logTime("cannot connect using SSL, trying unsecure");
            Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, ex);

            try {   // without SSL
                conn = DriverManager.getConnection(connectionStr, user, password);
                status = "... connected unsecurely";
                this.logTime("... connected unsecurely");
            } catch (SQLException e) {
                this.error(this, e.getMessage());
                status = "... connection failed";
                this.logTime("... connection failed");
                Logger.getLogger(DBConn.class.getName()).log(Level.SEVERE, null, e);
                return false;
            }
        }

        return true;
    }





}
