
package InsertBot;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.sql.*;
import java.text.DecimalFormat;


/**
 *
 * @author isebek
 */
public class InsBot {
    static String   DATA_DIR = "/data";
    static int      CLOCK_TICK = 60*24;
    static int      BATCH_COUNT = 150;
    static int      CLOCK_TICK_SLEEP = 500;
    static String   DATA_TABLE = "climate.data";

    private static class Clock {
        public static long  YEAR_MINUTES = 60*24*31*12;
        private long clock;
        public long month, day, hour, min;
        public int year;

        public void setYear(int year){
            this.year = year;
        }

        public void setClock(long clock){
            this.clock = clock;

            long realTime = clock;
            month = realTime / (60 * 24 * 31) + 1;
            realTime = realTime - (60 * 24 * 31) * (month - 1);
            day = realTime / (60 * 24) + 1;
            realTime = realTime - (60 * 24) * (day - 1);
            hour = realTime / (60);
            realTime = realTime - (60) * hour;
            min = realTime;

        }

        public long getClock(){
            return this.clock;
        }

    }

    private static class MeteoData{
        public int lineSTN, lineWBAN, lineTEMPobs, lineDEWPobs, lineSLPobs,
                lineSTPobs, lineVISIBobs, lineWDSPobs, lineFRSHTT;
        public float lineTEMP, lineDEWP, lineSLP, lineSTP, lineVISIB, lineWDSP, lineMXSPD,
                lineGUST, lineMAX, lineMIN, lineSNDP;
        public String linePRCP, lineYEARMODA;

        public int[] lineData;

        public int lineYear, lineMonth, lineDay;

        private Scanner fileSc;

        public MeteoData(String meteoFilename) throws FileNotFoundException{
            fileSc = new Scanner(new File(meteoFilename));
            // Skip first line in data
            fileSc.nextLine();
        }

        public boolean hasNext(){
            return fileSc.hasNext();
        }

        public void close(){
            fileSc.close();
        }

        public int getDayTimestamp(){
            return 60*24* ( (lineDay-1) + 31*(lineMonth-1));
        }

        public float fahr2cels(float f){
            return (f-32)*5/9;
        }

        public void readNextRecord(){
            String strLine = fileSc.nextLine().replace('*', ' ');
            Scanner sc = new Scanner(strLine);
            try{

                lineSTN         = sc.nextInt();
                lineWBAN        = sc.nextInt();
                lineYEARMODA    = sc.next();

                lineData        = new int[19];

                for(int i=0; i<19; i++){

                    if (i != 16){
                        float data = sc.nextFloat();
                        if (i == 0 || i == 14 || i == 15)
                            data = fahr2cels(data);

                        lineData[i] = Math.round(data * 100);
                    }
                    else
                        linePRCP = sc.next();

                }


                /*
                lineTEMP        = sc.nextFloat();
                lineTEMPobs     = sc.nextInt();
                lineDEWP        = sc.nextFloat();
                lineDEWPobs     = sc.nextInt();
                lineSLP         = sc.nextFloat();
                lineSLPobs      = sc.nextInt();
                lineSTP         = sc.nextFloat();
                lineSTPobs      = sc.nextInt();
                lineVISIB       = sc.nextFloat();
                lineVISIBobs    = sc.nextInt();
                lineWDSP        = sc.nextFloat();
                lineWDSPobs     = sc.nextInt();

                lineMXSPD       = sc.nextFloat();
                lineGUST        = sc.nextFloat();
                lineMAX         = sc.nextFloat();
                lineMIN         = sc.nextFloat();
                linePRCP = sc.next();
                  //float linePRCP        = sc.nextFloat();
                  //sc.nextByte();
                lineSNDP        = sc.nextFloat();
                lineFRSHTT      = sc.nextInt();
                 */

                lineYear    = Integer.parseInt( lineYEARMODA.substring(0, 4) );
                lineMonth   = Integer.parseInt( lineYEARMODA.substring(4, 6) );
                lineDay     = Integer.parseInt( lineYEARMODA.substring(6, 8) );

            } catch (java.util.InputMismatchException ex){
                System.err.println(strLine);
                ex.printStackTrace();
            }

        }

    }


    private static class MeteoLoop implements Runnable {

        int meteoID;
        int year;
        String meteoFilename;
        final Clock clock;
        DBConn connection;


        public MeteoLoop(String meteoFilename, int year, int meteoID, Clock clock, DBConn connection){
            this.meteoID        = meteoID;
            this.year           = year;
            this.meteoFilename  = meteoFilename;
            this.clock          = clock;
            this.connection     = connection;
        }

        private String intarray2String(int[] iarr){
            String str = "";
            for (int i=0; i<iarr.length; i++){
                str = str + ((i>0)?", ":"")  + (iarr[i]!=999990?iarr[i]:"'99990'");
            }
            return str;
        }

        public void run() {
            {
                FileWriter fstream = null;
                DecimalFormat numFormat = new DecimalFormat("#00.000000");
                try {
                    System.out.println("THREAD: year=" + year + " meteo=" + meteoID + " thID=" + Thread.currentThread().getName());
                    MeteoData meteoData = new MeteoData(meteoFilename);
                    fstream = new FileWriter("log/out_"+Thread.currentThread().getName()+".txt");
                    BufferedWriter outLog = new BufferedWriter(fstream);
                    long realTime = 0;
                    long month, day, hour, min;

                    boolean lineReaded = false;
                    do {
                        //System.out.println("Time "+ day + "." + month + "."+year +" "+ hour + ":" + min);

                        // access sync-clock
                        synchronized (clock) {
                            // Wait next clock-tick
                            clock.wait();
                            realTime    = clock.getClock();
                            month       = clock.month;
                            day         = clock.day;
                            hour        = clock.hour;
                            min         = clock.min;
                        }
              

                        
                        // File ended before end of year
                        if (lineReaded == false && !meteoData.hasNext()) {
                            break;
                        }

                        // time to renew record - new day, not loaded
                        if (min == 0 && hour == 0 && lineReaded == false) {
                            meteoData.readNextRecord();
                            lineReaded = true;
                        }

                        //System.out.println("Times: "+meteoData.lineYEARMODA+" "+meteoData.getDayTimestamp()+" "+year+""+month+""+day+" "+realTimePrev);
                        
                        // if read record is out-of-date
                        while (meteoData.hasNext() && meteoData.getDayTimestamp() < realTime) {
                            System.out.println("Times: " + meteoData.lineYEARMODA + " " + meteoData.getDayTimestamp() + " " + year + "" + month + "" + day + " " + realTime);
                            meteoData.readNextRecord();
                            lineReaded = false;
                            System.out.println("skipping line");
                        }

                        // If is current day
                        if (day == meteoData.lineDay && month == meteoData.lineMonth && year == meteoData.lineYear) {
                            lineReaded = false;

                            //Insert data into SQL
                            String q = "INSERT INTO " + DATA_TABLE + "(datum, station, data) VALUES ('" + year + "-" + month + "-" + day + "', '" + meteoData.lineSTN + "', ARRAY[" + intarray2String(meteoData.lineData) + "]);";
                            Statement stmt = connection.conn.createStatement();
                            long t1 = System.nanoTime();

                            try {
                                stmt.execute(q);
                            } catch (SQLException ex) {
                                Logger.getLogger(InsBot.class.getName()).log(Level.SEVERE, null, ex);
                            }

                            long t2 = System.nanoTime();

                            // if we know stats about execution, log it
                            if (stmt.getWarnings() != null){
                                String serverNotice = stmt.getWarnings().toString().replaceAll(" 00:00:", " ").replaceAll("NOTICE: ", "");
                                outLog.write(""+ (new java.util.Date()).getTime() +"; "+serverNotice + "; "+  numFormat.format((t2 - t1) * 0.000000001) + "\n");
                                outLog.flush();
                            }
                            
                        //else somethig goes out/wrong
                        } else if (min == 0 && hour == 0) {
                            //System.out.println("MISSING DATA "+ day + "." + month + "."+year +" "+ meteoFilename +" / WAITING FOR "+meteoData.lineDay +"."+ meteoData.lineMonth + " TS: "+meteoData.getDayTimestamp() +" "+realTimePrev);
                            System.err.print(".");
                        }
                    } while (Clock.YEAR_MINUTES > realTime);

                    // finally close all
                    meteoData.close();
                    connection.conn.close();
                    outLog.close();

                } catch (IOException ex) {
                    Logger.getLogger(InsBot.class.getName()).log(Level.SEVERE, null, ex);
                } catch (InterruptedException ex) {
                    System.err.println(ex);
                } catch (SQLException ex) {
                    Logger.getLogger(InsBot.class.getName()).log(Level.SEVERE, null, ex);
                }
            }


        }

    }



    /**
     * @param args the command line arguments
     */
    @SuppressWarnings("empty-statement")
    public static void main(String[] args) {
        Locale.setDefault(Locale.US);
        int clockSleep = CLOCK_TICK_SLEEP;
        int batchCount = BATCH_COUNT;

        if (args.length < 2){
            System.err.println("Usage: InsBot startYear finishYear [ clockSleep [ batchCount ] ]");
            return;
        }
        if (args.length >= 3) clockSleep = Integer.parseInt(args[2]);
        if (args.length == 4) batchCount = Integer.parseInt(args[3]);

        int yrStart = Integer.parseInt(args[0]);
        int yrEnd = Integer.parseInt(args[1]);
        Clock clock = new Clock();


        for (int year = yrStart; year <= yrEnd; year ++){
            System.out.println("================");
            System.out.println("Processing year: " + year);
            File dir = new File(year+DATA_DIR);
            String[] meteoFiles = dir.list();
            if (meteoFiles == null){
                System.out.println("No data.");
                continue;
            }


            for(int batch = 0; batch < meteoFiles.length; batch = batch + batchCount )
            {
                clock.setClock(0 - CLOCK_TICK);
                clock.setYear(year);
                ArrayList<Thread> threadList = new ArrayList<Thread>();

                // Process each meteo-file by thread
                for(int i=batch; i < Math.min(batch + batchCount, meteoFiles.length); i++){
                    int meteoID = Integer.parseInt( (meteoFiles[i]).substring(0,6) );
                    Thread t = new Thread(new MeteoLoop(year+DATA_DIR+"/"+meteoFiles[i],
                            year, meteoID, clock, new DBConn() ) );
                    threadList.add(t);
                    t.start();

                }

                // simulation cycle
                while ( Clock.YEAR_MINUTES > clock.getClock() ){

                        try {
                            Thread.sleep(clockSleep);
                        } catch (InterruptedException ex) {
                            System.err.println(ex);
                        }

                        synchronized(clock){
                            clock.setClock(clock.getClock() + CLOCK_TICK);
                            clock.notifyAll();
                        }

                        System.out.println("Time "+ clock.day + "." + clock.month + "."+clock.year );

                }

                try {
                    Thread.sleep(clockSleep);
                } catch (InterruptedException ex) {
                    Logger.getLogger(InsBot.class.getName()).log(Level.SEVERE, null, ex);
                }

                // Wait until all thread finished
                Iterator<Thread> threadIt = threadList.iterator();
                while (threadIt.hasNext()){
                    Thread t = threadIt.next();
                    if (t.isAlive())
                        t.interrupt(); // kill-down running

                }
            }

        }

    }

}
