/*
 * Decompiled with CFR 0.152.
 */
package retin;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import retin.Commons;

public class ReTIN {
    public static double maxRTimeout = 300.0;
    public static long sleepTime = 1000L;
    public static long batchIndex = 2000L;
    public static long batchWakeupCnt = 5L;
    public static long maximumStdevs = 3L;
    public static String dbSchema = "climate";
    public static String dbNotifyName = "climate_notify";
    public static String dbTable = "rt_id timestamp without time zone NOT NULL DEFAULT now(),datum date NOT NULL,station integer NOT NULL,data int4[]";
    public static String[] dbConstraints = new String[]{dbSchema + "_data_##_check CHECK ( rt_id >= '?RTF?' AND rt_id < '?RTL?' )", dbSchema + "_data_##_pk PRIMARY KEY (datum, station)", dbSchema + "_data_##_stations FOREIGN KEY (station) REFERENCES " + dbSchema + ".stations (id) MATCH SIMPLE ON UPDATE RESTRICT ON DELETE RESTRICT"};
    public static String[] dbIndexes = new String[]{dbSchema + "_data_##_rt_index ON " + dbSchema + ".data_&&(rt_id)", dbSchema + "_data_##_gin ON " + dbSchema + ".data_&& USING gin(data)"};
    public static String[] dbQueries = new String[]{"SELECT count(*) FROM " + dbSchema + ".data_index WHERE data @> ARRAY[##]", "SELECT count(*) FROM " + dbSchema + ".data_temp WHERE data @> ARRAY[##]"};
    Commons commons = new Commons();

    public ReTIN() {
        try {
            this.commons.conn.setAutoCommit(false);
        }
        catch (SQLException ex) {
            Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        ReTIN retin = new ReTIN();
        if (args.length > 0 && args[0].compareTo("clear") == 0) {
            retin.clearDB();
        }
        retin.maintenance_loop(0);
    }

    private void maintenance_loop(int insert_count_prev) {
        while (true) {
            try {
                while (true) {
                    Statement stmt_meta = this.commons.conn.createStatement();
                    ResultSet rset_meta = stmt_meta.executeQuery("SELECT * FROM " + dbSchema + ".data_meta WHERE id = 0");
                    rset_meta.next();
                    int insert_count = rset_meta.getInt("insert_count");
                    Timestamp rt_first = rset_meta.getTimestamp("rt_first");
                    Statement stmt = this.commons.conn.createStatement();
                    if ((long)(insert_count - insert_count_prev) >= batchIndex) {
                        double insert_millis = rset_meta.getDouble("insert_millis");
                        double insert_stdev = rset_meta.getDouble("insert_stdev");
                        int query_count = rset_meta.getInt("query_count");
                        double query_index_millis = rset_meta.getDouble("query_index_millis");
                        double query_index_stdev = rset_meta.getDouble("query_index_stdev");
                        double query_temp_millis = rset_meta.getDouble("query_temp_millis");
                        double query_temp_stdev = rset_meta.getDouble("query_temp_stdev");
                        double[] time_select = new double[dbQueries.length];
                        long t1 = System.currentTimeMillis();
                        stmt = this.commons.conn.createStatement();
                        ResultSet rset = stmt.executeQuery("SELECT max(rt_id) FROM " + dbSchema + ".data_temp");
                        if (!rset.next()) {
                            this.commons.error(rset, "SELECT max(rt_id) FROM " + dbSchema + ".data_temp");
                            continue;
                        }
                        long t2 = System.currentTimeMillis();
                        Timestamp rt_last = rset.getTimestamp(1);
                        rset.close();
                        double mean = insert_millis / (double)insert_count;
                        double stdev = Math.sqrt(insert_stdev / (double)insert_count - mean * mean);
                        if (mean + (double)maximumStdevs * stdev > maxRTimeout) {
                            this.commons.logTime("The system may not suffice the R-T condition (insert)!");
                        }
                        rset_meta.close();
                        stmt_meta.close();
                        this.commons.conn.commit();
                        sleepTime = (rt_last.getTime() - rt_first.getTime()) / (long)insert_count * batchIndex / batchWakeupCnt;
                        int rand = new Integer(this.getRndVal(1, 15) * 100);
                        t1 = System.currentTimeMillis();
                        stmt = this.commons.conn.createStatement();
                        String select = "SELECT " + dbSchema + ".querycount('" + dbQueries[0].replace("##", Integer.toString(rand)) + "')";
                        System.out.println(select);
                        stmt = this.commons.conn.createStatement();
                        stmt.execute(select);
                        t2 = System.currentTimeMillis();
                        String notice = stmt.getWarnings().getMessage().replaceAll("00:00:", "");
                        time_select[0] = Double.parseDouble(notice) * 1000.0;
                        stmt.close();
                        this.commons.conn.commit();
                        t1 = System.currentTimeMillis();
                        stmt = this.commons.conn.createStatement();
                        select = "SELECT " + dbSchema + ".querycount('" + dbQueries[1].replace("##", Integer.toString(rand)) + "')";
                        System.out.println(select);
                        stmt = this.commons.conn.createStatement();
                        stmt.execute(select);
                        t2 = System.currentTimeMillis();
                        notice = stmt.getWarnings().getMessage().replaceAll("00:00:", "");
                        time_select[1] = Double.parseDouble(notice) * 1000.0;
                        stmt.close();
                        this.commons.conn.commit();
                        stmt = this.commons.conn.createStatement();
                        stmt.executeUpdate("UPDATE climate.data_meta SET query_count=(query_count+1),  query_index_millis=(query_index_millis+" + time_select[0] + "), query_index_stdev=(query_index_stdev + (" + time_select[0] * time_select[0] + ")), " + " query_temp_millis=(query_temp_millis+" + time_select[1] + "), query_temp_stdev=(query_temp_stdev + (" + time_select[1] * time_select[1] + ")) " + " WHERE id=0");
                        stmt.close();
                        this.commons.conn.commit();
                        double index_mean = (query_index_millis += time_select[0]) / (double)(++query_count);
                        double index_stdev = Math.sqrt((query_index_stdev += time_select[0] * time_select[0]) / (double)query_count - index_mean * index_mean);
                        double temp_mean = (query_temp_millis += time_select[1]) / (double)query_count;
                        double temp_stdev = Math.sqrt((query_temp_stdev += time_select[1] * time_select[1]) / (double)query_count - temp_mean * temp_mean);
                        if (temp_mean >= index_mean || index_mean + (double)maximumStdevs * index_stdev > maxRTimeout) {
                            this.commons.conn.commit();
                            this.reindex();
                        }
                        insert_count_prev = 0;
                    }
                    this.commons.conn.commit();
                    stmt_meta.close();
                    this.commons.logTime("Going to sleep for " + sleepTime + " milliseconds");
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    this.commons.conn.rollback();
                }
                catch (SQLException ex1) {
                    Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex1);
                }
                continue;
            }
            catch (SQLException ex) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
                try {
                    this.commons.conn.rollback();
                    continue;
                }
                catch (SQLException ex1) {
                    Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex1);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reindex() {
        try {
            int i;
            int i2;
            Statement stmt_meta = this.commons.conn.createStatement();
            ResultSet rset_meta = stmt_meta.executeQuery("SELECT * FROM " + dbSchema + ".data_meta WHERE id=0");
            rset_meta.next();
            int insert_count = rset_meta.getInt("insert_count");
            Timestamp rt_first = rset_meta.getTimestamp("rt_first");
            double insert_millis = rset_meta.getDouble("insert_millis");
            double insert_stdev = rset_meta.getDouble("insert_stdev");
            double mean = insert_millis / (double)insert_count;
            double stdev = Math.sqrt(insert_stdev / (double)insert_count - mean * mean);
            int query_count = rset_meta.getInt("query_count");
            double query_index_millis = rset_meta.getDouble("query_index_millis");
            double query_index_stdev = rset_meta.getDouble("query_index_stdev");
            double query_temp_millis = rset_meta.getDouble("query_temp_millis");
            double query_temp_stdev = rset_meta.getDouble("query_temp_stdev");
            double index_mean = query_index_millis / (double)query_count;
            double imstt = query_index_stdev / (double)query_count - index_mean * index_mean;
            double index_stdev = imstt <= 0.0 ? 0.0 : Math.sqrt(imstt);
            double temp_mean = query_temp_millis / (double)query_count;
            double temp_stdev = Math.sqrt(query_temp_stdev / (double)query_count - temp_mean * temp_mean);
            Statement stmt = this.commons.conn.createStatement();
            ResultSet rset = stmt.executeQuery("SELECT max(rt_id) FROM " + dbSchema + ".data_temp");
            rset.next();
            Timestamp rt_last = rset.getTimestamp(1);
            rset.close();
            rset = stmt.executeQuery("SELECT max(id)+1 FROM " + dbSchema + ".data_meta");
            rset.next();
            int id = rset.getInt(1);
            rset.close();
            int arows = stmt.executeUpdate("UPDATE " + dbSchema + ".data_meta SET id=" + id + ", rt_last='" + rt_last.toString() + "', " + " insert_millis=" + mean + ", insert_stdev=" + stdev + ", " + " query_index_millis=" + index_mean + ", query_index_stdev=" + index_stdev + ", " + " query_temp_millis=" + temp_mean + ", query_temp_stdev=" + temp_stdev + " WHERE id = 0");
            stmt.executeUpdate("INSERT INTO " + dbSchema + ".data_meta(id, rt_first) VALUES(0, '" + rt_last + "')");
            stmt.close();
            this.commons.conn.commit();
            stmt = this.commons.conn.createStatement();
            stmt.execute("CREATE TABLE " + dbSchema + ".data_" + id + " AS SELECT * FROM " + dbSchema + ".data_temp WHERE rt_id < '" + rt_last + "'");
            stmt.close();
            this.commons.conn.commit();
            String constr = "ALTER TABLE climate.data_" + Integer.toString(id) + " ALTER COLUMN rt_id SET NOT NULL";
            stmt = this.commons.conn.createStatement();
            stmt.execute(constr);
            stmt.close();
            this.commons.conn.commit();
            for (i2 = 0; i2 < dbConstraints.length; ++i2) {
                constr = "ALTER TABLE " + dbSchema + ".data_" + id + " ADD CONSTRAINT " + dbConstraints[i2].replace("##", Integer.toString(id)).replace("?RTF?", rt_first.toString()).replace("?RTL?", rt_last.toString());
                try {
                    stmt = this.commons.conn.createStatement();
                    stmt.execute(constr);
                    stmt.close();
                    continue;
                }
                catch (SQLException ex) {
                    Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                finally {
                    this.commons.conn.commit();
                }
            }
            for (i2 = 0; i2 < dbIndexes.length; ++i2) {
                String index = "CREATE INDEX " + dbIndexes[i2].replace("##", Integer.toString(id)).replace("&&", Integer.toString(id));
                try {
                    stmt = this.commons.conn.createStatement();
                    stmt.execute(index);
                    stmt.close();
                    continue;
                }
                catch (SQLException ex) {
                    Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
                    continue;
                }
                finally {
                    this.commons.conn.commit();
                }
            }
            int index_first = 1;
            Timestamp index_rt_first = rt_first;
            if (id > 1) {
                stmt = this.commons.conn.createStatement();
                rset = stmt.executeQuery("SELECT rt_first FROM " + dbSchema + ".data_meta WHERE id=(" + index_first + ")");
                rset.next();
                index_rt_first = rset.getTimestamp(1);
                rset.close();
                stmt.close();
            }
            stmt = this.commons.conn.createStatement();
            stmt.execute("UPDATE " + dbSchema + ".data_meta SET index_first=" + index_first + " WHERE id=" + id);
            stmt.close();
            this.commons.conn.commit();
            String create = "CREATE TABLE " + dbSchema + ".data_itempex (" + dbTable + ")";
            stmt = this.commons.conn.createStatement();
            stmt.execute(create);
            for (i = 1; i <= id; ++i) {
                stmt.execute("ALTER TABLE " + dbSchema + ".data_" + i + " INHERIT " + dbSchema + ".data_itempex");
            }
            stmt.close();
            this.commons.conn.commit();
            stmt = this.commons.conn.createStatement();
            stmt.execute("ALTER TABLE " + dbSchema + ".data_" + id + " INHERIT " + dbSchema + ".data");
            stmt.close();
            stmt = this.commons.conn.createStatement();
            for (i = 1; i < id; ++i) {
                stmt.execute("ALTER TABLE " + dbSchema + ".data_" + i + " NO INHERIT " + dbSchema + ".data_index");
                if (i >= index_first) continue;
                stmt.execute("ALTER TABLE " + dbSchema + ".data_" + i + " NO INHERIT " + dbSchema + ".data");
            }
            stmt.close();
            try {
                stmt = this.commons.conn.createStatement();
                stmt.execute("DROP TABLE " + dbSchema + ".data_index");
            }
            catch (SQLException ex) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
            }
            stmt.close();
            try {
                stmt = this.commons.conn.createStatement();
                stmt.execute("ALTER TABLE  " + dbSchema + ".data_itempex RENAME TO data_index");
            }
            catch (SQLException ex) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
            }
            stmt.close();
            stmt = this.commons.conn.createStatement();
            stmt.execute("DELETE FROM " + dbSchema + ".data_temp WHERE rt_id < '" + rt_last.toString() + "'");
            stmt.close();
            this.commons.logTime("Created partition table # " + id + " && reindexing: sucess");
            this.commons.conn.commit();
        }
        catch (SQLException ex) {
            Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
            try {
                this.commons.conn.rollback();
            }
            catch (SQLException ex1) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
    }

    private int getRndVal(int min, int max) {
        return min + new Random(System.currentTimeMillis()).nextInt(max - min);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearDB() {
        try {
            Statement stmt;
            Statement stmt_meta = this.commons.conn.createStatement();
            ResultSet rset_meta = stmt_meta.executeQuery("SELECT * FROM " + dbSchema + ".data_meta");
            while (rset_meta.next()) {
                int id = rset_meta.getInt("id");
                try {
                    if (id <= 0) continue;
                    Statement stmt2 = this.commons.conn.createStatement();
                    stmt2.execute("DROP TABLE " + dbSchema + ".data_" + id);
                    stmt2.close();
                }
                catch (SQLException ex) {
                    this.commons.logTime("FAILED: DROP TABLE " + dbSchema + ".data_" + id);
                }
                finally {
                    this.commons.conn.commit();
                }
            }
            try {
                stmt = this.commons.conn.createStatement();
                stmt.execute("DROP TABLE " + dbSchema + ".data_itempex CASCADE");
                stmt.close();
            }
            catch (SQLException ex) {
                this.commons.logTime("Already DROPped: DROP TABLE " + dbSchema + ".data_itempex CASCADE");
            }
            finally {
                this.commons.conn.commit();
            }
            try {
                stmt = this.commons.conn.createStatement();
                stmt.execute("TRUNCATE TABLE " + dbSchema + ".data_temp");
                stmt.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
                this.commons.logTime("FAILED: TRUNCATE TABLE " + dbSchema + ".data_temp");
            }
            finally {
                this.commons.conn.commit();
            }
            try {
                stmt = this.commons.conn.createStatement();
                stmt.execute("TRUNCATE TABLE " + dbSchema + ".data_meta");
                stmt.executeUpdate("INSERT INTO " + dbSchema + ".data_meta(id) VALUES (0)");
                stmt.close();
            }
            catch (SQLException ex) {
                Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
                this.commons.logTime("FAILED: TRUNCATE TABLE " + dbSchema + ".data_meta");
            }
            finally {
                this.commons.conn.commit();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ReTIN.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

