/*------------------------------------------------------------------*/
/* EvoCCs_scatter						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Random.cpp - Random number generator implementation 		    */
/*            - implementation file                                 */
/*------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
//#include <process.h>
#include <unistd.h>
#include <math.h>
#include "Random.h"


using namespace std;


/**
 *  Random::DoubleRandom - Double random <0,1)
*/
double Random::DoubleRandom()
{
  long lo,hi,test;

  hi   = Seed / Q;
  lo   = Seed % Q;
  test = A*lo - R*hi;

  if (test>0)
    Seed = test;
  else
    Seed = test+M;

  return ((double) (Seed)/M);
}// end of Random::DoubleRandom
//--------------------------------------------------------------------------------


/**
 *  Random::IntGaussRandom - int gaus random
*/
int Random::IntGaussRandom(double mean, double variance){

  int i;
  double SUM = 0.0;
  for (i=0; i<12; i++)  SUM += DoubleRandom();
  return (SUM-6.0)*variance + mean;
}// end of Random::IntGaussRandom
//--------------------------------------------------------------------------------


/**
 *  Random::IntGaussRandom - int gaus random <Min..Max), mean >0, variance >0, Min>0, Max >0
*/
int Random::IntGaussRandom(double mean, double variance, int Min, int Max){

 int RandomInt = IntGaussRandom(mean, variance);
 
 return fabs((RandomInt % (Max-Min))) + Min;
}// end of Random::IntGaussRandom
//--------------------------------------------------------------------------------


/**
 *  Random::RandomSeed
*/
void Random::RandomSeed()
{
//  SetSeed(3);
   SetSeed(time(NULL) * getpid());
}// end of andom::RandomSeed
//--------------------------------------------------------------------------------


/**
 *  Random::RandomSeed
*/
Random::Random (Random& rnd){

   Q = rnd.Q;
   R = rnd.R;
   Seed = rnd.Seed;
}// end of Random::Random
//--------------------------------------------------------------------------------

