/*------------------------------------------------------------------*/
/* EvoCCs_scatter						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Port_check.h - UMDA port check heuristics	 		    */
/*                - header file		                            */
/*------------------------------------------------------------------*/


#ifndef Port_checkH
#define Port_checkH
//---------------------------------------------------------------------------

#include <vector>
#include <map>
#include <set>

#include "Chromozome.h"

using namespace std;

typedef map<int, int, less<int> > TPortUsage;
typedef set<int, less<int> > TFreeSteps;


/**
 *  TUsageOfSlots - Port ussage in slots
*/
class TUsageOfSlots{
  private:
      //-- Step Count --//
    int FStepCount;
    int FRowCount;
    int FColumnCount;
      //-- Usage of Senders' and Receivers' ports
    vector<TPortUsage> FRowPortUsage;
    vector<TPortUsage> FColumnPortUsage;

    Chromozome* Fchr;

      //-- Set Sender and Receiver port usage --//
    void SetPortUtilization();

      //-- GetFreeSteps --//
    void GetFreeSlots(TFreeSteps& FreeSteps, int Node, bool InRow);

      //-- Get correct time slot --//
    int GetCorrectStep(int Sender, int Receiver); 
    
    
      //-- returns Step index in the chr --//
    inline int GetStepIndex(int src, int dst) {return  (((FColumnCount*src +dst) << 1) + 1);}

       //-- disables a default constructor --//
    TUsageOfSlots();
  public:
      // -- Create an object and compute basic Ports' utilizations
    TUsageOfSlots(Chromozome* chr, int SenderCount, int ReceiverCount, int StepCount);

      //-- Is there a row collision? --//
    bool IsRowCollision(int Sender, int Step);
      //-- Is there a column collision? --//
    bool IsColumnCollision(int Receiver, int Step);

      //-- Set Correct slot for communication --// 
    int GetAndSetCorrectSlot(int Sender, int Receiver);

      //-- Set New usage for a port for given step --//
    void SetPortUsage(int Sender, int Receiver, int NewStep, int PreviousStep);
     
};// end of TUsageOfSlots
//---------------------------------------------------------------------------


#endif
