/*------------------------------------------------------------------*/
/* EvoCCs_scatter						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Chromozome.h - Impementation of chromozome		            */
/*              - header file		                            */
/*------------------------------------------------------------------*/

#ifndef _Chromozome_h_
#define _Chromozome_h_

#include <string>

using namespace std;

class Chromozome;

typedef double TComputeFitness(Chromozome& chr);

/**
  * Chromozome - class to maintain the chromosome data and routines
*/
class Chromozome{
  private:
    int *FGene;
    int FSize;
    bool FWasEvaluated;
    double FFitness;
    TComputeFitness* FComputeFitness;
  public :
    Chromozome(int ChromozomeSize, TComputeFitness* FitnessFunction);
    ~Chromozome(){delete [] FGene;};
    Chromozome(const Chromozome& chr);

    int& operator[] (int index){ return FGene[index]; };
    friend bool operator <(Chromozome chr1, Chromozome chr2)  {return (chr1.Fitness() < chr2.Fitness());};
    friend bool operator >(Chromozome chr1, Chromozome chr2)  {return (chr1.Fitness() > chr2.Fitness());};
    friend bool operator <=(Chromozome chr1, Chromozome chr2)  {return (chr1.Fitness() <= chr2.Fitness());};
    friend bool operator >=(Chromozome chr1, Chromozome chr2)  {return (chr1.Fitness() >= chr2.Fitness());};
    friend bool operator ==(Chromozome chr1, Chromozome chr2)  {return (chr1.Fitness() == chr2.Fitness());};
    friend bool operator !=(Chromozome chr1, Chromozome chr2)  {return (chr1.Fitness() != chr2.Fitness());};

    Chromozome & operator = (const Chromozome &chr);

    void SetNoEvaluated() { FWasEvaluated = false;};
    string ToString();
    int Length() { return FSize;};
    double Fitness();


};// end of Chromozome
//--------------------------------------------------------------------------------
#endif
