/*------------------------------------------------------------------*/
/* EvoCCs_scatter						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Chromozome.cpp - Impementation of chromozome		            */
/*                - implementation file                             */
/*------------------------------------------------------------------*/
#include <stdio.h>
#include <string>
#include "Chromozome.h"
#include <iostream>
using namespace std;


/**
  * Chromozome::Chromozome - constructor
*/
Chromozome::Chromozome(int ChromozomeSize, TComputeFitness* FitnessFunction){
    FSize = ChromozomeSize;
    FWasEvaluated = false;
    FFitness = 0;
    FGene = new int [FSize];
    for (int i=0; i<FSize;i++) FGene[i] = 0;
    FComputeFitness =  FitnessFunction;
}// end of Chromozome::Chromozome
//--------------------------------------------------------------------------------


/**
  * Chromozome::Chromozome - copy constructor
*/
Chromozome::Chromozome(const Chromozome& chr){
  FSize = chr.FSize;
  FWasEvaluated = chr.FWasEvaluated;
  FFitness = chr.FFitness;

  FGene = new int [FSize];
  for (int i=0; i<FSize;i++) FGene[i] = chr.FGene[i];

  FComputeFitness =  chr.FComputeFitness;
}// end of Chromozome::Chromozome
//--------------------------------------------------------------------------------


/**
  * Chromozome & Chromozome::operator = 
*/
Chromozome & Chromozome::operator = (const Chromozome &chr){
  if(&chr!=this) {

    FWasEvaluated = chr.FWasEvaluated;
    FFitness = chr.FFitness;

    if (FSize != chr.FSize) {
      if (FGene!=NULL) delete [] FGene;
      FSize = chr.FSize;
      FGene = new int [FSize];
    }
    for (int i=0; i<FSize;i++) FGene[i] = chr.FGene[i];

    FComputeFitness =  chr.FComputeFitness;

    return *this;
  }
}// Chromozome & Chromozome::operator = 
//--------------------------------------------------------------------------------



/**
  * double Chromozome::Fitness() - provide fitness function of the chromozome
*/
double Chromozome::Fitness(){
  if (!FWasEvaluated) {   if (*FComputeFitness != NULL) FFitness = FComputeFitness(*this);
                          else FFitness = 0;
                        FWasEvaluated = true;
                      }
  return FFitness;
}// end of Chromozome::Fitness()
//--------------------------------------------------------------------------------


/**
  * Chromozome::ToString - conversion to string
*/
string Chromozome::ToString(){

 string S="(";

 char Pom[10];
 for (int i=0; i<FSize-1; i++){
   sprintf(Pom,"%d, ",FGene[i]);
   S += Pom;
 }
 sprintf(Pom,"%d)",FGene[FSize-1]);
 S +=  Pom;
 return S;
}// end of Chromozome::ToString
//--------------------------------------------------------------------------------

