/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Random.h - Random number generator implementation 		    */
/*          - header file 	                                    */
/*------------------------------------------------------------------*/
#ifndef _Random_h_
#define _Random_h_

using namespace std;

/**
 *  Random class
*/
class Random{
 private:
   static const int M = 2147483647;     // modulus of PMMLCG (the default is 2147483647 = 2^31 - 1)
   static const int A = 16807;          // the default is 16807
   long Q;       // M / A
   long R;       // M mod A
   long Seed;    // a number between 1 and m-1

 public:
  Random() { Q= M/A; R = M%A; RandomSeed(); };
  Random(long NewSeed) { Q= M/A; R = M%A; Seed = NewSeed; };

  Random (Random& rnd);
  double DoubleRandom(); // <0..1>
  inline int IntRandom(int UpperBound) { return ((int) (DoubleRandom() * UpperBound)); };
  int IntGaussRandom(int UpperBound, double variance=1, double mean =0);
  inline void SetSeed(long NewSeed) {Seed = NewSeed; };
  void RandomSeed();
};// end of Random
//--------------------------------------------------------------------------------

#endif
