/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Random.cpp - Random number generator implementation 		    */
/*            - implementation file                                 */
/*------------------------------------------------------------------*/

#include <stdio.h>
#include <time.h>
//#include <process.h>
#include <unistd.h>
#include <math.h>
#include "Random.h"


using namespace std;

const double sqrt2PI = sqrt(2*M_PI);

/**
 *  Random::DoubleRandom - Double random <0,1)
*/
double Random::DoubleRandom()
{
  long lo,hi,test;

  hi   = Seed / Q;
  lo   = Seed % Q;
  test = A*lo - R*hi;

  if (test>0)
    Seed = test;
  else
    Seed = test+M;

  return ((double) (Seed)/M);
}// end of Random::DoubleRandom
//--------------------------------------------------------------------------------


/**
 *  Random::IntGaussRandom - int gaus random
*/
int Random::IntGaussRandom(int UpperBound, double variance , double mean){
  double FirstMember = pow(variance*sqrt2PI,-1);

  double SecondMember = -(pow(((IntRandom(UpperBound)-mean)/variance),2))/2;
  return (int)( FirstMember*exp(SecondMember));
}// end of Random::IntGaussRandom
//--------------------------------------------------------------------------------

/**
 *  Random::RandomSeed
*/
void Random::RandomSeed()
{
//  SetSeed(3);
   SetSeed(time(NULL) * getpid());
}// end of andom::RandomSeed
//--------------------------------------------------------------------------------


/**
 *  Random::RandomSeed
*/
Random::Random (Random& rnd){

   Q = rnd.Q;
   R = rnd.R;
   Seed = rnd.Seed;

} // end of Random::Random
//--------------------------------------------------------------------------------

