/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/*	   jarosjir@fit.vutbr.cz                                    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* Population.cpp - UMDA population implementation 		    */
/*                - implementation file                             */
/*------------------------------------------------------------------*/


#include "Population.h"
#include "Chromozome.h"
#include <vector>
#include <algorithm>
#include <iterator>
#include <iostream>
#include <functional>
using namespace std;


/**
 *  Population::InitPopulation - initialization of population
*/
void Population::InitPopulation(int PopulationSize){
 Chromozome * chr;

 for (int i=0; i<PopulationSize;i++){
  chr = new Chromozome(FChromozomeSize,FComputeFunction);
  if (*FInitChromozome != NULL) FInitChromozome(*chr);


  FPopulation.push_back(*chr);
 }
}// end of Population::InitPopulation
//--------------------------------------------------------------------------------


/**
 *  Population::Population - copy constructor
*/
Population::Population(const Population &pop){
   int PopSize = pop.FPopulation.size();

   FChromozomeSize = pop.FChromozomeSize;
   FInitChromozome = pop.FInitChromozome;
   FComputeFunction = pop.FComputeFunction;

   FPopulation.clear();
   FPopulation.reserve(PopSize);
   // -- Copy of whole population

   for (int i=0; i<PopSize;i++)
     FPopulation.push_back(pop.FPopulation[i]);
}// end of Population::Population 
//--------------------------------------------------------------------------------

/**
 *  Population::operator =
*/
Population & Population::operator = (const Population &pop){
   int PopSize = pop.FPopulation.size();

   FChromozomeSize = pop.FChromozomeSize;
   FInitChromozome = pop.FInitChromozome;
   FComputeFunction = pop.FComputeFunction;

   FPopulation.clear();
   FPopulation.reserve(PopSize);
   // -- Copy of whole population

   for (int i=0; i<PopSize;i++)
     FPopulation.push_back(pop.FPopulation[i]);
}// end of Population::operator = 
//--------------------------------------------------------------------------------

/**
 *  Population::Add
*/
void Population::Add(Chromozome& chr){
  FPopulation.push_back(chr);
}// end of Population::Add
//--------------------------------------------------------------------------------

/**
 *  Population::Sort
*/
void Population::Sort(){
  sort(FPopulation.begin(),FPopulation.end());
}// end of Population::Sort
//--------------------------------------------------------------------------------

/**
 *  Population::Delete
*/
void Population::Delete(int index){
  FPopulation.erase(FPopulation.begin() + index);
}// end of Population::Delete
//--------------------------------------------------------------------------------


