/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* GeneticOperators.h - the core of UMDA genetic operators          */
/*                    - header file                                 */
/*------------------------------------------------------------------*/


#ifndef _GeneticOperators_h_
#define _GeneticOperators_h_
#include "Chromozome.h"
#include "Random.h"

using namespace std;

//- function prototypes --//
typedef void MutationFunction(Chromozome& chr);
typedef void CrossoverFunction(Chromozome Parent1,Chromozome Parent2,
        Chromozome& Offspring1,Chromozome& Offspring2);

void InvertMutation(Chromozome& chr);
void SwapMutation(Chromozome& chr);


void SimpleCrossover(Chromozome Parent1,Chromozome Parent2,
        Chromozome& Offspring1,Chromozome& Offspring2);


void Simple3Crossover(Chromozome Parent1,Chromozome Parent2,
        Chromozome& Offspring1,Chromozome& Offspring2);


#endif

