/*------------------------------------------------------------------*/
/* EvoCCs_boradcast						    */
/*   Tool for evolutionary design of broadcast-based                */
/*   collective communications on wormhole networks                 */
/*                                                                  */
/* Author: Jiri Jaros						    */
/* 	   Brno University of Technology			    */
/* 	   GPL Licence, 2010					    */
/*------------------------------------------------------------------*/

/*------------------------------------------------------------------*/
/* GeneticOperators.cpp - the core of UMDA genetic operators        */
/*                       - implementation file                      */
/*------------------------------------------------------------------*/


#include "GeneticOperators.h"
#include "Random.h"
#include "Chromozome.h"
#include "GeneticCore.h"


using namespace std;
extern Random RandomGenerator;




/**
  *  InvertMutation - Invert one bit in chromosome
*/
void InvertMutation(Chromozome& chr){
 int Pos = RandomGenerator.IntRandom(chr.Length());

 if (chr[Pos] == 0) chr[Pos] = 1;
 else chr[Pos] = 0;
}// end of InvertMutation
//--------------------------------------------------------------------------------


/**
  *  SwapMutation - Invert one bit in chromosome
*/
void SwapMutation(Chromozome& chr){
  int First = RandomGenerator.IntRandom(chr.Length());
  int Second;
  while ((Second = RandomGenerator.IntRandom(chr.Length())) == First);

  int Pom = chr[First];
  chr[First] = chr[Second];
  chr[Second] = Pom;
}// end of SwapMutation
//--------------------------------------------------------------------------------


/**
  *   SimpleCrossover - Simple one point crossover
*/
void SimpleCrossover(Chromozome Parent1,Chromozome Parent2,
        Chromozome& Offspring1,Chromozome& Offspring2){

  int CrossLine = RandomGenerator.IntRandom(Parent1.Length());

  while (!((CrossLine >= 1) && (CrossLine < (Parent1.Length()-2))))
    CrossLine = RandomGenerator.IntRandom(Parent1.Length());

  // -- First part of offsprings
  for (int i=0; i<CrossLine;i++){
   Offspring1[i] = Parent1[i];
   Offspring2[i] = Parent2[i];
  }

  // -- Second part of offsprings
  for (int i=CrossLine; i<Parent1.Length();i++){
   Offspring1[i] = Parent2[i];
   Offspring2[i] = Parent1[i];
  }
}// end of SimpleCrossover
//--------------------------------------------------------------------------------


/**
  *   Simple3Crossover - Simple one point crossover, on gene boundaries
*/
void Simple3Crossover(Chromozome Parent1,Chromozome Parent2,
        Chromozome& Offspring1,Chromozome& Offspring2){


  int GeneNum = Parent1.Length() / 3;
  int CrossLine = RandomGenerator.IntRandom(GeneNum);

  while (!((CrossLine >= 1) && (CrossLine < (GeneNum-2))))
    CrossLine = RandomGenerator.IntRandom(GeneNum);

  // -- First part of offsprings
  for (int i=0; i<(CrossLine * 3);i++){
   Offspring1[i] = Parent1[i];
   Offspring2[i] = Parent2[i];
  }

  // -- Second part of offsprings
  for (int i=(CrossLine*3); i<Parent1.Length();i++){
   Offspring1[i] = Parent2[i];
   Offspring2[i] = Parent1[i];
  }
}// end of Simple3Crossover
//--------------------------------------------------------------------------------


