#ifndef _LIBPCLINES_H
#define _LIBPCLINES_H

/********************************************************/
/* structures                                           */
/********************************************************/
typedef struct PCpoint
{
 int x;
 int y;
}PCpoint;

typedef struct PCpoint32F
{
 float x;
 float y;
}PCpoint32F;

typedef struct PCline
{
 float rho;
 float angle;
}PCline;

typedef struct ImageData8U
{
 unsigned char *data;
 unsigned int width;
 unsigned int height;
}ImageData8U;

typedef struct ImageData32S
{
 long int *data;
 unsigned int width;
 unsigned int height;
}ImageData32S;

typedef struct SpaceParameters
{
 float distance;
 float vertical_offset;
 float scale;
}SpaceParameters;

/********************************************************/
/* prototypes                                           */
/********************************************************/
#ifdef __cplusplus
extern "C" {
#endif

void getEdgePoints(PCline *line, unsigned int image_width, unsigned int image_height, PCpoint *A, PCpoint *B);
int pcLinesStandard(ImageData8U *inputImg, PCline *line, unsigned int lineCount, unsigned int spaceW, unsigned int spaceHs, unsigned int threshold, unsigned int local_max_radius);
int pcLinesStandardWeighted(ImageData8U *inputImg, PCline *lines, unsigned int lineCount, unsigned int spaceW, unsigned int spaceH, unsigned int threshold, unsigned int local_max_radius);
int pcLinesEdgeOrientation(ImageData8U *gradientImg, ImageData8U *maskImg, PCline *lines, unsigned int lineCount, unsigned int estimation_radius, unsigned int spaceW, unsigned int spaceH, unsigned int threshold, unsigned int local_max_radius);

#ifdef __cplusplus
	   }
#endif

#endif
