/*                                                              coding: utf-8
 ============================================================================
 Name        : src/EditPattern.cpp
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Tel.num.pattern filter items-specific edit view and related
               container control (setting item list).

 Notes:

 ============================================================================
*/


// INCLUDES

#include "UiEditPattern.h"

// locally needed, system:

#include <stringloader.h>             // StringLoader | CommonEngine.lib


// locally needed, own:

#include <SmsAlerts_a9e722b4.rsg>     // R_SMS_ALERTS_EDIT_SETTING_ITEM_LIST_PATTERN
#include "SmsAlerts.hrh"              // ESmsAlertsEditPatternViewId
#include "UiEdit.hrh"                 // ESmsAlertsEditSettingLastCommonItem, ...


// LIBS
//
// see UiEditBase.cpp, plus
//
// CommonEngine.lib        // StringLoader



// CAP
//
// see UiEditBase.cpp


// METHODS IMPLEMENTATION


// ===========================================================================
// CEditPatternView
// ===========================================================================

// ---------------------------------------------------------------------------
// CEditPatternView::CEditPatternView()
// C++ default constructor.
// ---------------------------------------------------------------------------
//
CEditPatternView::CEditPatternView(MDataForEditPattern& aDataForEditPattern)
    : CEditBaseView(R_SMS_ALERTS_EDIT_SETTING_ITEM_LIST_PATTERN)
    , iDataForEditPattern(aDataForEditPattern)
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CEditPatternView::NewLC()
// Two-phased construction.
// ---------------------------------------------------------------------------
//
CEditPatternView*
CEditPatternView::NewLC(MDataForEditPattern& aDataForEditPattern)
    {
    CEditPatternView* self = new (ELeave) CEditPatternView(aDataForEditPattern);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ---------------------------------------------------------------------------
// CEditPatternView::NewL()
// Two-phased construction.
// ---------------------------------------------------------------------------
//
CEditPatternView*
CEditPatternView::NewL(MDataForEditPattern& aDataForEditPattern)
    {
    CEditPatternView* self = NewLC(aDataForEditPattern);
    CleanupStack::Pop(self);
    return self;
    }

// ---------------------------------------------------------------------------
// CEditPatternView::Id()
// Returns ID of the view.
// ---------------------------------------------------------------------------
//
TUid
CEditPatternView::Id()
const
    {
    return TUid::Uid(ESmsAlertsEditPatternViewId);
    }

// ---------------------------------------------------------------------------
// CEditPatternView::HandleCommandL()
// Handle a command for this view.
// ---------------------------------------------------------------------------
//
void
CEditPatternView::HandleCommandL(TInt aCommand)
    {
    if (aCommand == ESmsAlertsEditResetStatusPaneCommand)
        {
        SetupStatusPaneL();
        }
    else
        {
        CEditBaseView::HandleCommandL(aCommand);
        }
    }

// ---------------------------------------------------------------------------
// CEditPatternView::StatusPaneTextLC()
// TODO
// ---------------------------------------------------------------------------
//
HBufC*
CEditPatternView::StatusPaneTextLC() const
    {
    HBufC* naviLabelPrefix =
        StringLoader::LoadL( R_SMS_ALERTS_EDIT_NAVIGATION_LABEL_PREFIX_PATTERN,
                             iCoeEnv );
    TFilterItemHeader& patternName(iDataForEditPattern.GetPatternHeader().iPatternName);
    HBufC* naviLabel =
        naviLabelPrefix->ReAlloc(naviLabelPrefix->Length() + patternName.Length());
    CleanupStack::PushL(naviLabel);
    if (naviLabel)
        {
        TDes naviLabelPtr(naviLabel->Des());
        naviLabelPtr.Append(patternName);
        return naviLabel;
        }
    else
        {
        return naviLabelPrefix;
        }
    }


// ===========================================================================
// CEditBaseContainer
// ===========================================================================

// ---------------------------------------------------------------------------
// CEditGroupContainer::CEditGroupContainer()
// Default C++ constructor.
// ---------------------------------------------------------------------------
//
CEditPatternContainer::CEditPatternContainer( TUid aViewId,
                                              TSaTelnumPatternCacheItem& aPatternHeader,
                                              TSaFilterItemSettings& aSettings,
                                              MEikCommandObserver* aCommandObserver )
    : CEditBaseContainer(aViewId, aSettings, aCommandObserver)
    , iPatternHeader(aPatternHeader)
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CEditPatternContainer::~CEditPatternContainer()
// Destructor.
// ---------------------------------------------------------------------------
//
CEditPatternContainer::~CEditPatternContainer()
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CEditPatternContainer::CreateSettingItemL()
// Create one setting item at a time, identified by id.
// ---------------------------------------------------------------------------
//
CAknSettingItem*
CEditPatternContainer::CreateSettingItemL(TInt aId)
    {
    if (aId < ESmsAlertsEditSettingLastCommonItem)
        // common setting items
        {
        return CEditBaseContainer::CreateSettingItemL(aId);
        }
    else
        // specific setting items
        {
        switch (aId)
            {
            case ESmsAlertsEditSettingItemPatternName:
                {
                CAknTextSettingItem* item = new (ELeave)
                    CAknTextSettingItem(aId, iPatternHeader.iPatternName);
                return item;
                }
            case ESmsAlertsEditSettingItemPatternMask:
                {
                CAknTextSettingItem* item = new (ELeave)
                    CAknTextSettingItem(aId, iPatternHeader.iPatternMask);
                return item;
                }
            }
        }

    return NULL;
    }

// ---------------------------------------------------------------------------
// CEditPatternContainer::EditItemL()
// Edit the setting item identified by the given id and store
// the changes into the store.
// ---------------------------------------------------------------------------
//
void
CEditPatternContainer::EditItemL(TInt aIndex, TBool aCalledFromMenu)
    {
    CAknSettingItem* item = (*SettingItemArray())[aIndex];

    if (item->Identifier() < ESmsAlertsEditSettingLastCommonItem)
        {
        CEditBaseContainer::EditItemL(aIndex, aCalledFromMenu);
        }
    else
        {
        CAknSettingItemList::EditItemL(aIndex, aCalledFromMenu);
        iEdited = ETrue;
        item->StoreL();
        if (item->Identifier() == ESmsAlertsEditSettingItemPatternName)
            {
            iCommandObserver->ProcessCommandL(ESmsAlertsEditResetStatusPaneCommand);
            }
        }
    }

