/*                                                              coding: utf-8
 ============================================================================
 Name        : src/EditGroup.cpp
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Sender group filter items-specific edit view and related
               container control (setting item list).

 Notes:

 ============================================================================
*/


// INCLUDES

#include "UiEditGroup.h"


// locally needed, system:

#include <stringloader.h>             // StringLoader | CommonEngine.lib


// locally needed, own:

#include <SmsAlerts_a9e722b4.rsg>     // R_SMS_ALERTS_EDIT_SETTING_ITEM_LIST_GROUP
#include "SmsAlerts.hrh"              // ESmsAlertsEditGroupViewId
#include "UiEdit.hrh"                 // ESmsAlertsEditSettingLastCommonItem


// LIBS
//
// see UiEditBase.cpp, plus
//
// CommonEngine.lib        // StringLoader


// CAP
//
// see UiEditBase.cpp


// METHODS IMPLEMENTATION


// ===========================================================================
// CEditGroupView
// ===========================================================================

// ---------------------------------------------------------------------------
// CEditGroupView::CEditGroupView()
// C++ default constructor.
// ---------------------------------------------------------------------------
//
CEditGroupView::CEditGroupView(MDataForEditGroup& aDataForEditGroup)
    : CEditBaseView(R_SMS_ALERTS_EDIT_SETTING_ITEM_LIST_GROUP)
    , iDataForEditGroup(aDataForEditGroup)
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CEditGroupView::NewLC()
// Two-phased construction.
// ---------------------------------------------------------------------------
//
CEditGroupView*
CEditGroupView::NewLC(MDataForEditGroup& aDataForEditGroup)
    {
    CEditGroupView* self = new (ELeave) CEditGroupView(aDataForEditGroup);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ---------------------------------------------------------------------------
// CEditGroupView::NewL()
// Two-phased construction.
// ---------------------------------------------------------------------------
//
CEditGroupView*
CEditGroupView::NewL(MDataForEditGroup& aDataForEditGroup)
    {
    CEditGroupView* self = NewLC(aDataForEditGroup);
    CleanupStack::Pop(self);
    return self;
    }

// ---------------------------------------------------------------------------
// CEditGroupView::Id()
// Returns ID of the view.
// ---------------------------------------------------------------------------
//
TUid
CEditGroupView::Id()
const
    {
    return TUid::Uid(ESmsAlertsEditGroupViewId);
    }

// ---------------------------------------------------------------------------
// CEditGroupView::HandleCommandL()
// Handle a command for this view.
// ---------------------------------------------------------------------------
//
void
CEditGroupView::HandleCommandL(TInt aCommand)
    {
    CEditBaseView::HandleCommandL(aCommand);
    }

// ---------------------------------------------------------------------------
// CEditGroupView::StatusPaneTextLC()
// TODO
// ---------------------------------------------------------------------------
//
HBufC*
CEditGroupView::StatusPaneTextLC() const
    {
    HBufC* naviLabelPrefix =
        StringLoader::LoadL( R_SMS_ALERTS_EDIT_NAVIGATION_LABEL_PREFIX_GROUP,
                             iCoeEnv );
    TFilterItemHeader& groupName(iDataForEditGroup.GetGroupHeader());
    HBufC* naviLabel =
        naviLabelPrefix->ReAlloc(naviLabelPrefix->Length() + groupName.Length());
    CleanupStack::PushL(naviLabel);
    if (naviLabel)
        {
        TDes naviLabelPtr(naviLabel->Des());
        naviLabelPtr.Append(groupName);
        return naviLabel;
        }
    else
        {
        return naviLabelPrefix;
        }
    }


// ===========================================================================
// CEditBaseContainer
// ===========================================================================

// ---------------------------------------------------------------------------
// CEditGroupContainer::CEditGroupContainer()
// Default C++ constructor.
// ---------------------------------------------------------------------------
//
CEditGroupContainer::CEditGroupContainer( TUid aViewId,
                                          TSaFilterItemSettings& aSettings,
                                          MEikCommandObserver* aCommandObserver )
    :  CEditBaseContainer(aViewId, aSettings, aCommandObserver)
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CEditGroupContainer::~CEditGroupContainer()
// Destructor.
// ---------------------------------------------------------------------------
//
CEditGroupContainer::~CEditGroupContainer()
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CEditGroupContainer::CreateSettingItemL()
// Create one setting item at a time, identified by id.
// ---------------------------------------------------------------------------
//
CAknSettingItem*
CEditGroupContainer::CreateSettingItemL(TInt aId)
    {
    if (aId < ESmsAlertsEditSettingLastCommonItem)
        // common setting items
        {
        return CEditBaseContainer::CreateSettingItemL(aId);
        }

    return NULL;
    }

// ---------------------------------------------------------------------------
// CEditGroupContainer::EditItemL()
// Edit the setting item identified by the given id and store
// the changes into the store.
// ---------------------------------------------------------------------------
//
void
CEditGroupContainer::EditItemL(TInt aIndex, TBool aCalledFromMenu)
    {
    CAknSettingItem* item = (*SettingItemArray())[aIndex];

    if (item->Identifier() < ESmsAlertsEditSettingLastCommonItem)
        {
        CEditBaseContainer::EditItemL(aIndex, aCalledFromMenu);
        }
    else
        {
        CAknSettingItemList::EditItemL(aIndex, aCalledFromMenu);
        iEdited = ETrue;
        item->StoreL();
        }
    }
