/*                                                              coding: utf-8
 ============================================================================
 Name        : src/SaEngineModuleNotifyUI.cpp
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : UI part of the engine's module for notification about incoming
               SMS.

 Notes:

 ============================================================================
*/


// INCLUDES

#include "SaEngineModuleNotifyUI.h"

// for SaEngineModuleNotifyUI.h:

#include <eikappui.h>                      // CEikAppUi
#include <aknglobalconfirmationquery.h>    // CAknGlobalConfirmationQuery

// locally needed, system:
#include <akniconutils.h>                  // AknIconUtils
#include <aknsconstants.h>                 // KAknsIIDQgnNoteImMessage
#include <aknsitemid.h>                    // TAknsItemID
#include <stringloader.h>                  // StringLoader
#include <barsread.h>                      // TResourceReader

#include <avkon.rsg>                       // R_AVKON_SOFTKEYS_SHOW_EXIT
#include <avkon.mbg>                       // EMbmAvkonQgn_note_message, ...
#include <avkon.hrh>                       // EAknSoftkeyShow, ...


// locally needed, own:

#include "SmsAlerts.pan"                   // panics
#include "SaEngineModuleDispatch.h"        // MSV_MY_FOLDERS_ENTRY_ID

#include <SmsAlerts_a9e722b4.rsg>          // R_SMS_ALERTS_NOTEUI_SINGULAR, ...


// LIBS
//
// euser.lib                    // CActive, CActiveScheduler
// aknnotify.lib                // CAknGlobalConfirmationQuery
// eiksrv.lib                   // CAknGlobalConfirmationQuery
// aknicon.lib                  // AknIconUtils
// eikcore.lib                  // CEikAppUi
// commonengine.lib             // StringLoader
// bafl.lib                     // TResourceReader

// CAPS
//
//


// CONSTANTS

const TVwsViewId messagingViewUid = TVwsViewId( TUid::Uid(0x100058C5) /*app*/,
                                                TUid::Uid(0x02) /*view*/);
const TUid myFoldersMsgUid = { MSV_MY_FOLDERS_ENTRY_ID };


// METHODS IMPLEMENTATION

// ===========================================================================
// CSaEngineModuleNotifyUI
// ===========================================================================

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::CSaEngineModuleNotifyUI()
// Default C++ constructor.
// ---------------------------------------------------------------------------
//

CSaEngineModuleNotifyUI::CSaEngineModuleNotifyUI( CEikAppUi* aAppUi,
                                                  MSaEngineModuleNotifyUIObserver& aNotifyUIObserver )
    : CActive(EPriorityStandard)
    , iAppUi(aAppUi)
    , iNotifyUIObserver(aNotifyUIObserver)
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::NewLC()
// Two-phased construction.
// ---------------------------------------------------------------------------
//
CSaEngineModuleNotifyUI*
CSaEngineModuleNotifyUI::NewLC( CEikAppUi* aAppUi,
                                MSaEngineModuleNotifyUIObserver& aNotifyUIObserver )
    {
    CSaEngineModuleNotifyUI* self =
        new (ELeave) CSaEngineModuleNotifyUI(aAppUi, aNotifyUIObserver);
    CleanupStack::PushL(self);
    self->ConstructL();
    return self;
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::NewL()
// Two-phased construction.
// ---------------------------------------------------------------------------
//
CSaEngineModuleNotifyUI*
CSaEngineModuleNotifyUI::NewL( CEikAppUi* aAppUi,
                               MSaEngineModuleNotifyUIObserver& aNotifyUIObserver )
    {
    CSaEngineModuleNotifyUI* self = NewLC(aAppUi, aNotifyUIObserver);
    CleanupStack::Pop(self);
    return self;
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::ConstructL()
// Second phase construction.
// ---------------------------------------------------------------------------
//
void
CSaEngineModuleNotifyUI::ConstructL()
    {
    CActiveScheduler::Add(this);

    TResourceReader resReader;
    CCoeEnv::Static()->CreateResourceReaderLC( resReader,
                                               R_SMS_ALERTS_NOTEUI_PLURAL_SECOND_RANGE_START );
    iPluralSecondRangeStart = resReader.ReadInt8();
    CleanupStack::PopAndDestroy(); // resReader (?)
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::~CSaEngineModuleNotifyUI()
// Destructor.
// ---------------------------------------------------------------------------
//
CSaEngineModuleNotifyUI::~CSaEngineModuleNotifyUI()
    {
    NoteCancel();
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::NoteAddL()
// Increase the number of received messages, about which the note informs.
// ---------------------------------------------------------------------------
//
void
CSaEngineModuleNotifyUI::NoteAddL()
    {
    iNumOfMessages++;
    if (iNumOfMessages == 1)
        {
        if (iGlobalConfirmationQuery)
            {
            NoteCancel();
            }
        TAknsItemID skinNoteMessage = KAknsIIDQgnNoteMessage;
        iGlobalConfirmationQuery = CAknGlobalConfirmationQuery::NewL();
        iGlobalConfirmationQuery->SetImageSkinId(skinNoteMessage);

        if (iNoteText)
            {
            delete iNoteText;
            }
        iNoteText = StringLoader::LoadL(R_SMS_ALERTS_NOTEUI_SINGULAR, iNumOfMessages);
        iGlobalConfirmationQuery
            ->ShowConfirmationQueryL(iStatus, *iNoteText,
                                     R_AVKON_SOFTKEYS_SHOW_EXIT, 0,
                                     AknIconUtils::AvkonIconFileName(),
                                     EMbmAvkonQgn_note_message,
                                     EMbmAvkonQgn_note_message_mask,
                                     CAknQueryDialog::ENoTone,
                                     ETrue);
        SetActive();
        }
    else if (iNumOfMessages > 1)
        {
        __ASSERT_ALWAYS(iGlobalConfirmationQuery, Panic(ESmsAlertsNotifyUi));

        iGlobalConfirmationQuery->CancelConfirmationQuery();
        Cancel();
        if (iNoteText)
            {
            delete iNoteText;
            }
        iNoteText = StringLoader::LoadL( (iNumOfMessages < iPluralSecondRangeStart) ?
                                             R_SMS_ALERTS_NOTEUI_PLURAL_1 :
                                             R_SMS_ALERTS_NOTEUI_PLURAL_2,
                                         iNumOfMessages );
        iGlobalConfirmationQuery
            ->ShowConfirmationQueryL( iStatus, *iNoteText,
                                      R_AVKON_SOFTKEYS_SHOW_EXIT, 0,
                                      AknIconUtils::AvkonIconFileName(),
                                      EMbmAvkonQgn_note_message,
                                      EMbmAvkonQgn_note_message_mask,
                                      CAknQueryDialog::ENoTone,
                                      ETrue );
        SetActive();
        }
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::NoteCancel()
// Increase the number of received messages, about which the note informs.
// ---------------------------------------------------------------------------
//
void
CSaEngineModuleNotifyUI::NoteCancel()
    {
    if (iGlobalConfirmationQuery)
        {
        iGlobalConfirmationQuery->CancelConfirmationQuery();
        delete iGlobalConfirmationQuery;
        iGlobalConfirmationQuery = NULL;
        }
    iNumOfMessages = 0;
    if (iNoteText)
        {
        delete iNoteText;
        iNoteText = NULL;
        }
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::RunL()
// Active object's request complete handler.
// ---------------------------------------------------------------------------
//
void
CSaEngineModuleNotifyUI::RunL()
    {
    TInt a = iStatus.Int();
    switch (a)
        {
        case EAknSoftkeyShow:
            iAppUi->ActivateViewL(messagingViewUid, myFoldersMsgUid, KNullDesC8);
            break;
        default:
            break;
        }
    iNotifyUIObserver.NoteClosedL();
    NoteCancel();
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::DoCancel()
// Active object's request cancel handler.
// ---------------------------------------------------------------------------
//
void
CSaEngineModuleNotifyUI::DoCancel()
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CSaEngineModuleNotifyUI::RunError()
// Active object's RunL leave handler.
// ---------------------------------------------------------------------------
//
TInt
CSaEngineModuleNotifyUI::RunError(TInt aError)
    {
    NoteCancel();
    return aError;
    }

