/*                                                              coding: utf-8
 ============================================================================
 Name        : src/Application.cpp
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Application's entry point and class representation.

 Notes:

 ============================================================================
*/

/**
 * \~english  \mainpage SMS Alerts
 * \~czech    \mainpage Hlásič SMS (SMS Alerts)
 *
 * \~english  \htmlinclude mainpage_en.html
 * \~czech    \htmlinclude mainpage_cs.html
 */


// INCLUDES

#include "Application.h"
#include "Document.h"

#include <coemain.h>                // CCoeEnv

#ifdef EKA2
#include <eikstart.h>
#endif


// cone.lib


// FUNCTIONS IMPLEMENTATION


#ifdef EKA2

// ---------------------------------------------------------------------------
// NewApplication()
// Called by the application framework to construct the application object.
// ---------------------------------------------------------------------------
//
LOCAL_C CApaApplication*
NewApplication()
    {
    return new CApplication;
    }

// ---------------------------------------------------------------------------
// E32Main()
// This standard export is the entry point for all Series 60 applications.
// ---------------------------------------------------------------------------
//
GLDEF_C TInt
E32Main()
    {
    return EikStart::RunApplication( NewApplication );
    }

#else     // Series 60 2.x main DLL program code


// ---------------------------------------------------------------------------
// NewApplication()
// This standard export constructs the application object.
// ---------------------------------------------------------------------------
//
EXPORT_C CApaApplication*
NewApplication()
    {
    return new CApplication;
    }


// ---------------------------------------------------------------------------
// E32Dll()
// This standard export is the entry point for all Series 60 applications.
// ---------------------------------------------------------------------------
//
GLDEF_C TInt
E32Dll(TDllReason /*reason*/)
    {
    return KErrNone;
    }


#endif // EKA2


// METHODS IMPLEMENTATION

// ===========================================================================
// CApplication
// ===========================================================================

// ---------------------------------------------------------------------------
// CApplication::AppDllUid()
// Returns the application's UID.
// ---------------------------------------------------------------------------
//
TUid
CApplication::AppDllUid() const
    {
    return KUidSmsAlertsApplication;
    }

// ---------------------------------------------------------------------------
// CApplication::CreateDocumentL()
// Creates the application's document.
// ---------------------------------------------------------------------------
//
CApaDocument*
CApplication::CreateDocumentL()
    {
    return CDocument::NewL(*this, this->iCoeEnv->FsSession());
    }

