/*                                                              coding: utf-8
 ============================================================================
 Name        : src/AppUi.cpp
 Author      : Jan Pokorný <xpokor04@stud.fit.vutbr.cz>

 Description : Application's user interface model based on view architecture.

 Notes:

 ============================================================================
*/


// INCLUDES

#include "AppUi.h"

// for SmsAlertsAppUi.h:

#include <aknnavide.h>              // CAknNavigationDecorator
#include <akntabgrp.h>              // CAknTabGroup

#include "SaDataModel.h"            // MSaDataCache


// locally needed, system:

#include <apgtask.h>                // TApaTask
#include <w32std.h>                 // RWindowGroup


// locally needed, own:

#include "SmsAlerts.hrh"

#include "Application.h"

#include "UiListGroup.h"
#include "UiEditGroup.h"

#include "UiListPattern.h"
#include "UiEditPattern.h"


// LIBS
//
// avkon.lib     // CAknViewAppUi, CAknNavigationDecorator, CAknTabGroup
// eikcore.lib   // CAknViewAppUi
// eiksrv.lib    // CAknViewAppUi
// apgrfx.lib    // TApaTask
// ws32.lib      // RWindowGroup


// CAPS
//
// None (est.)


// METHODS IMPLEMENTATION


// ===========================================================================
// CAppUi
// ===========================================================================

// ---------------------------------------------------------------------------
// CAppUi::CAppUi()
// Default C++ constructor.
// ---------------------------------------------------------------------------
//
CAppUi::CAppUi(MSaDataCache* aDataCache)
    : iDataCache(aDataCache)
    // no need for initialize filteredMessages to zero explicitly
    {
    // No implementation required.
    }

// ---------------------------------------------------------------------------
// CAppUi::ConstructL()
// Second phase constructor.
// ---------------------------------------------------------------------------
//
void
CAppUi::ConstructL()
    {
    BaseConstructL(EAknEnableSkin);
    InitializeViewsL();
    }

// ---------------------------------------------------------------------------
// CAppUi::~CAppUi()
// Destructor.
// ---------------------------------------------------------------------------
//
/**
 * The appui's destructor removes the container from the control
 * stack and destroys it.
 */
CAppUi::~CAppUi()
    {
    if (iNaviDecorator)
        {
        delete iNaviDecorator;
        iNaviDecorator = NULL;
        }
    }

// ---------------------------------------------------------------------------
// CAppUi::InitializeViewsL()
// Initialization of application's views.
// ---------------------------------------------------------------------------
//
void
CAppUi::InitializeViewsL()
    {
    CAknNavigationControlContainer* naviPane =
        (CAknNavigationControlContainer*) StatusPane()
                                          ->ControlL(TUid::Uid(EEikStatusPaneUidNavi));
    iNaviDecorator = naviPane->ResourceDecorator();
    if (iNaviDecorator)
        {
        iNaviTabs = (CAknTabGroup*) iNaviDecorator->DecoratedControl();
        }

    // sender group items list view -- default view
    iListGroupView = CListGroupView::NewL( TUid::Uid(ESmsAlertsEditGroupViewId),
                                                    iDataCache );
    AddViewL(iListGroupView);
    SetDefaultViewL(*iListGroupView);
    SetActiveTabByViewId(iListGroupView->Id());

    // tel.num. pattern items list view
    iListPatternView = CListPatternView::NewL( TUid::Uid(ESmsAlertsEditPatternViewId),
                                                        iDataCache );
    AddViewL(iListPatternView);

    // sender group item edit view
    iEditGroupView =
        CEditGroupView::NewL(*(static_cast<CListGroupView*>(iListGroupView)));
    AddViewL(iEditGroupView);

    // tel.num. pattern item edit view
    iEditPatternView =
        CEditPatternView::NewL(*(static_cast<CListPatternView*>(iListPatternView)));
    AddViewL(iEditPatternView);
    }

// ---------------------------------------------------------------------------
// CAppUi::SetActiveTabByViewId()
// Highlight the tab corresponding to active view.
// ---------------------------------------------------------------------------
//
void
CAppUi::SetActiveTabByViewId(TUid aViewId)
    {
    if (iNaviTabs && iNaviTabs->TabIndexFromId(aViewId.iUid) != KErrNotFound)
        {
        iNaviTabs->SetActiveTabById(aViewId.iUid);
        }
    }

// ---------------------------------------------------------------------------
// CAppUi::HandleCommandL()
// Handles commands.
// ---------------------------------------------------------------------------
//
void
CAppUi::HandleCommandL(TInt aCommand)
    {
    TBool commandHandled = EFalse;
    switch (aCommand)
        { // code to dispatch to the AppUi's menu and CBA commands

        case EAknSoftkeyBack:
            commandHandled = HandleRightSoftKeyPressedL();
            break;
        default:
            break;
        }

    if (!commandHandled)
        {
        if (aCommand == EAknSoftkeyExit || aCommand == EEikCmdExit)
            {
            Exit();
            }
        }
    }

// ---------------------------------------------------------------------------
// CAppUi::HandleResourceChangeL()
// Handles a change to the application's resources.
// ---------------------------------------------------------------------------
//
void
CAppUi::HandleResourceChangeL(TInt aType)
    {
    CAknViewAppUi::HandleResourceChangeL( aType );
    }

//---------------------------------------------------------------------
// CAppUi::HandleKeyEventL()
// Handles key events.
// ---------------------------------------------------------------------------
//
TKeyResponse
CAppUi::HandleKeyEventL( const TKeyEvent& aKeyEvent,
                         TEventCode /*aType*/ )
    {
    // The inherited HandleKeyEventL is private and cannot be called
    TVwsViewId activeViewId;
    if ( GetActiveViewId(activeViewId) == KErrNone
         && iNaviTabs->TabIndexFromId(activeViewId.iViewUid.iUid) == KErrNotFound )
        {
        return EKeyWasNotConsumed;
        }

    TInt active = iNaviTabs->ActiveTabIndex();
    TInt count = iNaviTabs->TabCount();

    switch (aKeyEvent.iCode)
        {
        case EKeyLeftArrow:
            if (active > 0)
                {
                active--;
                ActivateLocalViewL(TUid::Uid(iNaviTabs->TabIdFromIndex(active)));
                return EKeyWasConsumed;
                }
            break;
        case EKeyRightArrow:
            if (active + 1 < count)
                {
                active++;
                ActivateLocalViewL(TUid::Uid( iNaviTabs->TabIdFromIndex(active)));
                return EKeyWasConsumed;
                }
            break;
        default:
            return EKeyWasNotConsumed;
        }

    return EKeyWasNotConsumed;
    }

//---------------------------------------------------------------------
// CAppUi::HandleViewDeactivation()
// Handles the deactivation of the view.
// ---------------------------------------------------------------------------
//
void
CAppUi::HandleViewDeactivation( const TVwsViewId& aViewIdToBeDeactivated,
                                const TVwsViewId& aNewlyActivatedViewId )
    {
    CAknViewAppUi::HandleViewDeactivation( aViewIdToBeDeactivated,
                                           aNewlyActivatedViewId );
    if (aNewlyActivatedViewId.iAppUid == KUidSmsAlertsApplication)
        {
        SetActiveTabByViewId(aNewlyActivatedViewId.iViewUid);
        }
    }

//---------------------------------------------------------------------
// CAppUi::HandleRightSoftKeyPressedL()
// Handles the event of pressing right soft key.
// ---------------------------------------------------------------------------
//
TBool
CAppUi::HandleRightSoftKeyPressedL()
    {
    TApaTask task(iEikonEnv->WsSession());
    task.SetWgId(iCoeEnv->RootWin().Identifier());
    task.SendToBackground();
    return ETrue;
    }

